<div class="card shadow-sm mb-3">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0"><i class="bi bi-bag"></i> Thông tin đơn hàng</h5>
    </div>
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Chọn khách hàng <span class="text-danger">*</span></label>
                <select name="customer_id" id="customerSelect" class="form-select" required>
                    <option value="">-- Chọn khách hàng --</option>
                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($customer['id']); ?>"
                                data-lead-id="<?php echo e($customer['lead_id']); ?>"
                                <?php echo e(old('customer_id') == $customer['id'] ? 'selected' : ''); ?>>
                            <?php echo e($customer['display']); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <input type="hidden" name="lead_id" id="leadIdInput" value="<?php echo e(old('lead_id')); ?>">
            </div>

            <div class="col-md-6">
                <label class="form-label">Ngày đặt hàng <span class="text-danger">*</span></label>
                <input type="date"
                       name="order_date"
                       class="form-control"
                       value="<?php echo e(old('order_date', date('Y-m-d'))); ?>"
                       required>
            </div>

            <div class="col-md-6">
                <label class="form-label">Kho xuất <span class="text-danger">*</span></label>
                <select name="warehouse_id" id="warehouseSelect" class="form-select" required>
                    <option value="">-- Chọn kho --</option>
                    <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wh): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($wh['id']); ?>" <?php echo e(old('warehouse_id') == $wh['id'] ? 'selected' : ''); ?>>
                            <?php echo e($wh['name']); ?> - <?php echo e($wh['location']); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>

        <div id="customerInfo" class="mt-3 p-3 bg-light rounded" style="display: none;">
            <h6 class="text-primary mb-2"><i class="bi bi-person"></i> Thông tin khách hàng</h6>
            <div class="row small">
                <div class="col-md-6">
                    <p class="mb-1"><strong>Loại khách:</strong> <span id="customerType"></span></p>
                    <p class="mb-1"><strong>Khu vực:</strong> <span id="customerRegion"></span></p>
                </div>
                <div class="col-md-6">
                    <p class="mb-1"><strong>Tổng đơn đã mua:</strong> <span id="customerOrders"></span></p>
                    <p class="mb-1"><strong>Công nợ:</strong> <span id="customerDebt" class="text-danger"></span></p>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/orders/partials/order-info.blade.php ENDPATH**/ ?>