
<?php $__env->startSection('title', 'Danh sách khách hàng'); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h1 class="fw-bold text-uppercase text-secondary">DANH SÁCH KHÁCH HÀNG</h1>
            <button class="btn btn-primary"
                    onclick="openCustomerForm()">
                <i class="bi bi-plus-lg"></i> Thêm mới
            </button>
        </div>
        
        <form action="<?php echo e(route('customers.index')); ?>" method="GET" class="mb-3">
            <div class="card shadow-sm mb-3">
                <div class="card-body">
                    <div class="row g-2 align-items-end">
                        <div class="col-md-3">
                            <label class="form-label small">Tìm kiếm</label>
                            <input type="text" name="search" class="form-control form-control-sm"
                                   value="<?php echo e(request('search')); ?>"
                                   placeholder="Tên, SĐT, Email...">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label small">Khu vực</label>
                            <select name="region_id" class="form-select form-select-sm">
                                <option value="">-- Tất cả --</option>
                                <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($region->id); ?>" <?php echo e(request('region_id') == $region->id ? 'selected' : ''); ?>>
                                        <?php echo e($region->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label small">Loại khách</label>
                            <select name="customer_type_id" class="form-select form-select-sm">
                                <option value="">-- Tất cả --</option>
                                <?php $__currentLoopData = $customerTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($type->id); ?>" <?php echo e(request('customer_type_id') == $type->id ? 'selected' : ''); ?>>
                                        <?php echo e($type->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label small">Trạng thái</label>
                            <select name="customer_status" class="form-select form-select-sm">
                                <option value="">-- Tất cả --</option>
                                <option value="lead" <?php echo e(request('customer_status') == 'lead' ? 'selected' : ''); ?>>Lead</option>
                                <option value="member" <?php echo e(request('customer_status') == 'member' ? 'selected' : ''); ?>>Member</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label small">Người phụ trách</label>
                            <select name="owner_id" class="form-select form-select-sm">
                                <option value="">-- Tất cả --</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>" <?php echo e(request('owner_id') == $user->id ? 'selected' : ''); ?>>
                                        <?php echo e($user->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button type="submit" class="btn btn-primary btn-sm w-100">
                                <i class="bi bi-search"></i> Lọc
                            </button>
                        </div>
                    </div>
                    <?php if(request()->hasAny(['search', 'region_id', 'customer_type_id', 'customer_status', 'owner_id'])): ?>
                        <div class="mt-2">
                            <a href="<?php echo e(route('customers.index')); ?>" class="btn btn-sm btn-outline-secondary">
                                <i class="bi bi-x-circle"></i> Xóa bộ lọc
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </form>
        
        <div class="table-responsive shadow-sm">
            <table class="table table-striped table-bordered align-middle table-hover text-center">
                <thead class="table-dark small">
                <tr>
                    <th><input type="checkbox"></th>
                    <th>Action</th>
                    <th>Ngày liên hệ</th>
                    <th>Nguồn</th>
                    <th>Tên Facebook</th>
                    <th>Link Facebook</th>
                    <th>Tên Zalo</th>
                    <th>Số điện thoại</th>
                    <th>Loại khách</th>
                    <th>Trạng thái</th>
                    <th>Ghi chú</th>
                    <th>Người phụ trách</th>
                    <th>Ngày mua hàng</th>
                    <th>Sản phẩm đã mua</th>
                    <th>Số tiền khách đã mua</th>
                    <th>Hình thức thanh toán</th>
                    <th>Đánh giá</th>
                    <th>Khu vực</th>
                    <th>Ngày cập nhật cuối</th>
                    <th>Người nhập</th>
                    <th>Ghi chú marketing</th>
                </tr>
                </thead>
                <tbody class="small">
                <?php $__empty_1 = true; $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><input type="checkbox"></td>
                        <td>
                            <div class="btn-group btn-group-sm" role="group">
                                <a href="<?php echo e(route('customers.show', $c->id)); ?>" class="btn btn-outline-info" title="Xem chi tiết">
                                    <i class="bi bi-eye-fill"></i>
                                </a>
                                <a class="btn btn-outline-warning"
                                   onclick="openCustomerForm('<?php echo e(route('customers.popup-form', $c->id)); ?>')" title="Sửa">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <form action="<?php echo e(route('customers.destroy', $c->id)); ?>"
                                      method="POST" class="d-inline-block">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button class="btn btn-outline-danger"
                                            onclick="return confirm('Xóa khách hàng này?')" title="Xóa">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                        
                        <td><?php echo e($c->latestLead->contact_date ?? '-'); ?></td>
                        
                        <td><?php echo e($c->latestLead->source->name ?? 'N/A'); ?></td>
                        
                        <td><?php echo e($c->facebook_name); ?></td>
                        <td>
                            <?php if($c->facebook_link): ?>
                                <a href="<?php echo e($c->facebook_link); ?>" target="_blank">Xem link</a>
                            <?php else: ?> - <?php endif; ?>
                        </td>
                        
                        <td><?php echo e($c->zalo_id); ?></td>
                        
                        <td><?php echo e($c->phone); ?></td>
                        
                        <td><?php echo e($c->customerType->name ?? 'N/A'); ?></td>
                        
                        <td>
                            <span class="badge <?php echo e($c->customer_status == 'member' ? 'bg-success' : 'bg-warning'); ?>">
                                <?php echo e(ucfirst($c->customer_status)); ?>

                            </span>
                        </td>
                        
                        <td class="text-start"><?php echo e($c->latestLead->note ?? '-'); ?></td>
                        
                        <td><?php echo e($c->assignedUser->name ?? 'Chưa gán'); ?></td>
                        
                        <td><?php echo e($c->latestOrder->order_date ?? '-'); ?></td>
                        
                        <td>
                            <?php echo e($c->latestOrder?->orderItems?->pluck('product.name')?->join(', ') ?? '-'); ?>

                        </td>
                        
                        <td>
                            <?php if($c->latestPayment): ?>
                                <?php echo e(number_format($c->latestPayment->amount, 0, ',', '.')); ?> đ
                            <?php else: ?> - <?php endif; ?>
                        </td>
                        
                        <td><?php echo e($c->latestPayment->method->method_name ?? '-'); ?></td>
                        
                        <td><?php echo e($c->is_potential ? '⭐ Tiềm năng' : '-'); ?></td>
                        
                        <td><?php echo e($c->region->name ?? '-'); ?></td>
                        
                        <td><?php echo e($c->updated_at?->format('d/m/Y H:i')); ?></td>
                        
                        <td><?php echo e($c->creator->name ?? 'N/A'); ?></td>
                        
                        <td class="text-start text-muted"><?php echo e($c->latestLead->marketing_note ?? '-'); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="21" class="text-center text-muted py-3">
                            Không có dữ liệu khách hàng.
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <div class="mt-3">
            <?php echo e($customers->links('pagination::bootstrap-5')); ?>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/customers/index.blade.php ENDPATH**/ ?>