<?php use Carbon\Carbon; ?>


<?php $__env->startSection('title', 'Chi tiết đơn hàng #' . $order->order_code); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-4">
        
        <div class="d-flex justify-content-between align-items-center mb-3 mt-3">
            <div>
                <h1 class="fw-bold text-uppercase text-secondary mb-1">ĐƠN HÀNG #<?php echo e($order->order_code); ?></h1>
                <p class="text-muted small mb-0">
                    <i class="bi bi-calendar3"></i> Tạo ngày <?php echo e(optional($order->created_at)->format('d/m/Y H:i')); ?>

                    <span class="mx-1">|</span>
                    <i class="bi bi-person-circle"></i> Bởi <?php echo e(optional($order->creator)->name ?? 'Unknown'); ?>

                </p>
            </div>
            <div class="d-flex gap-2">
                <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Quay lại
                </a>

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $order)): ?>
                    <a href="<?php echo e(route('orders.edit', $order->id)); ?>" class="btn btn-warning">
                        <i class="bi bi-pencil"></i> Sửa
                    </a>
                <?php endif; ?>
            </div>
        </div>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <i class="bi bi-check-circle-fill"></i> <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <i class="bi bi-exclamation-triangle-fill"></i> <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        
        <div class="row mb-4">
            <div class="col-12">
                <div class="card shadow-sm border-start border-4"
                     style="border-left-color: <?php echo e($order->currentStatusType->color ?? '#6c757d'); ?> !important;">
                    <div class="card-body py-3">
                        <div class="row align-items-center">
                            
                            <div class="col-md-3 border-end">
                                <h6 class="text-muted small mb-1">TRẠNG THÁI HIỆN TẠI</h6>
                                <span class="badge rounded-pill px-3 py-2 fs-6"
                                      style="background-color: <?php echo e($order->currentStatusType->color ?? '#6c757d'); ?>">
                                    <?php echo e($order->currentStatusType->name ?? 'Không xác định'); ?>

                                </span>
                            </div>

                            
                            <div class="col-md-3 border-end">
                                <h6 class="text-muted small mb-1">BỘ PHẬN ĐANG GIỮ</h6>
                                
                                <p class="mb-0 fw-bold fs-5 text-primary">
                                    <?php echo e(method_exists($order, 'getDepartmentName') ? $order->getDepartmentName() : ucfirst($order->current_department)); ?>

                                </p>
                            </div>

                            
                            <div class="col-md-3 border-end">
                                <h6 class="text-muted small mb-1">DỰ KIẾN GIAO HÀNG</h6>
                                <p class="mb-0 fw-bold">
                                    <?php if($order->estimated_delivery): ?>
                                        <?php echo e(Carbon::parse($order->estimated_delivery)->format('d/m/Y')); ?>

                                        <small class="text-muted fw-normal">(<?php echo e(Carbon::parse($order->estimated_delivery)->diffForHumans()); ?>)</small>
                                    <?php else: ?>
                                        <span class="text-muted fst-italic">-- Chưa xác định --</span>
                                    <?php endif; ?>
                                </p>
                            </div>

                            
                            <div class="col-md-3 text-end">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('submit', $order)): ?>
                                    <form action="<?php echo e(route('orders.submit', $order->id)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-primary w-100"
                                                onclick="return confirm('Bạn có chắc chắn muốn gửi đơn hàng này đi duyệt?')">
                                            <i class="bi bi-send"></i> Gửi duyệt ngay
                                        </button>
                                    </form>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('approve', $order)): ?>
                                    <a href="<?php echo e(route('orders.approval-form', $order->id)); ?>" class="btn btn-success w-100 pulse-animation">
                                        <i class="bi bi-clipboard-check"></i> Xử lý duyệt
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            
            <div class="col-lg-8">

                
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light fw-bold text-uppercase text-secondary">
                        <i class="bi bi-person-vcard"></i> Thông tin khách hàng
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="mb-2">
                                    <label class="text-muted small">Tên khách hàng:</label>
                                    <div class="fw-bold"><?php echo e($order->lead->customer->name); ?></div>
                                </div>
                                <div class="mb-2">
                                    <label class="text-muted small">Số điện thoại:</label>
                                    <div>
                                        <a href="tel:<?php echo e($order->lead->customer->phone); ?>" class="text-decoration-none">
                                            <?php echo e($order->lead->customer->phone); ?>

                                        </a>
                                    </div>
                                </div>
                                <div>
                                    <label class="text-muted small">Phân loại:</label>
                                    <div>
                                        <span class="badge bg-info text-dark">
                                            <?php echo e($order->lead->customer->customerType->name ?? 'N/A'); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-2">
                                    <label class="text-muted small">Email:</label>
                                    <div><?php echo e($order->lead->customer->email ?? '---'); ?></div>
                                </div>
                                <div class="mb-2">
                                    <label class="text-muted small">Khu vực:</label>
                                    <div><?php echo e($order->lead->customer->region->name ?? '---'); ?></div>
                                </div>
                                <div>
                                    <label class="text-muted small">Địa chỉ:</label>
                                    <div><?php echo e($order->lead->customer->address ?? '---'); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light fw-bold text-uppercase text-secondary d-flex justify-content-between">
                        <span><i class="bi bi-box-seam"></i> Chi tiết sản phẩm</span>
                        <span class="badge bg-secondary"><?php echo e($order->items->count()); ?> mặt hàng</span>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                <tr class="text-secondary small text-uppercase">
                                    <th class="ps-3" style="width: 5%">#</th>
                                    <th style="width: 45%">Sản phẩm</th>
                                    <th style="width: 15%" class="text-end">Đơn giá</th>
                                    <th style="width: 15%" class="text-center">Số lượng</th>
                                    <th style="width: 20%" class="text-end pe-3">Thành tiền</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="text-center ps-3"><?php echo e($loop->iteration); ?></td>
                                        <td>
                                            <div class="fw-bold text-primary"><?php echo e($item->product->name); ?></div>
                                            <div class="small text-muted">Mã SKU: <?php echo e($item->product->sku ?? 'N/A'); ?></div>
                                        </td>
                                        <td class="text-end font-monospace"><?php echo e(number_format($item->unit_price, 0, ',', '.')); ?></td>
                                        <td class="text-center fw-bold"><?php echo e($item->quantity); ?></td>
                                        <td class="text-end pe-3 font-monospace fw-bold"><?php echo e(number_format($item->line_total, 0, ',', '.')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot class="table-light border-top">
                                <tr>
                                    <td colspan="4" class="text-end fw-bold text-uppercase py-3">Tổng giá trị đơn hàng:</td>
                                    <td class="text-end pe-3 py-3">
                                        <span class="fs-5 fw-bold text-danger"><?php echo e(number_format($order->total_amount, 0, ',', '.')); ?> đ</span>
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

                
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light fw-bold text-uppercase text-secondary d-flex justify-content-between align-items-center">
                        <span><i class="bi bi-wallet2"></i> Lịch sử thanh toán</span>
                        <?php
                            $paid = $order->payments->sum('amount');
                            $remain = $order->total_amount - $paid;
                            $percent = $order->total_amount > 0 ? ($paid / $order->total_amount) * 100 : 0;
                        ?>
                        <div class="progress" style="width: 150px; height: 10px;">
                            <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo e($percent); ?>%"></div>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if($order->payments->count() > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-sm table-striped">
                                    <thead>
                                    <tr>
                                        <th>Ngày TT</th>
                                        <th>Số tiền</th>
                                        <th>Phương thức</th>
                                        <th>Người ghi nhận</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $order->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(Carbon::parse($payment->payment_date)->format('d/m/Y')); ?></td>
                                            <td class="fw-bold text-success">+<?php echo e(number_format($payment->amount, 0, ',', '.')); ?></td>
                                            <td><span class="badge bg-light text-dark border"><?php echo e($payment->method->method_name ?? 'N/A'); ?></span></td>
                                            <td><small><?php echo e($payment->recordedBy->name ?? 'System'); ?></small></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-center text-muted my-2">Chưa có giao dịch thanh toán nào.</p>
                        <?php endif; ?>

                        <div class="d-flex justify-content-between border-top pt-2 mt-2">
                            <span class="text-muted">Đã thanh toán: <strong><?php echo e(number_format($paid, 0, ',', '.')); ?> đ</strong></span>
                            <span class="text-danger">Còn lại: <strong><?php echo e(number_format($remain, 0, ',', '.')); ?> đ</strong></span>
                        </div>
                    </div>
                </div>

                
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light fw-bold text-uppercase text-secondary">
                        <i class="bi bi-clock-history"></i> Nhật ký xử lý
                    </div>
                    <div class="card-body">
                        <div class="timeline">
                            <?php $__empty_1 = true; $__currentLoopData = $timeline; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="timeline-item pb-3 ps-4 position-relative border-start border-2 ms-2">
                                    <div class="position-absolute start-0 translate-middle-x bg-white" style="top: 0;">
                                        <i class="bi bi-check-circle-fill text-<?php echo e($item->to_department == 'completed' ? 'success' : 'primary'); ?>"></i>
                                    </div>
                                    <div class="ms-2">
                                        <div class="d-flex justify-content-between">
                                            <strong><?php echo e($item->statusType->name ?? 'Thay đổi trạng thái'); ?></strong>
                                            <small class="text-muted"><?php echo e($item->changed_at ? Carbon::parse($item->changed_at)->format('d/m/Y H:i') : ''); ?></small>
                                        </div>
                                        <p class="mb-1 small text-muted">
                                            <?php if($item->from_department): ?>
                                                <?php echo e(ucfirst($item->from_department)); ?> <i class="bi bi-arrow-right"></i>
                                            <?php endif; ?>
                                            <span class="badge bg-secondary"><?php echo e(ucfirst($item->to_department)); ?></span>
                                        </p>
                                        <div class="p-2 bg-light rounded small fst-italic">
                                            "<?php echo e($item->note ?? 'Không có ghi chú'); ?>"
                                        </div>
                                        <div class="small mt-1 text-muted">
                                            <i class="bi bi-person"></i> Thực hiện: <?php echo e($item->changedBy->name ?? 'Hệ thống'); ?>

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="text-center text-muted">Chưa có lịch sử ghi nhận.</div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-lg-4">
                
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-dark text-white text-uppercase fw-bold small">
                        <i class="bi bi-info-square"></i> Thông tin nội bộ
                    </div>
                    <div class="card-body">
                        <table class="table table-sm table-borderless mb-0">
                            <tr>
                                <td class="text-muted">Mã đơn:</td>
                                <td class="fw-bold text-end font-monospace"><?php echo e($order->order_code); ?></td>
                            </tr>
                            <tr>
                                <td class="text-muted">Ngày đặt:</td>
                                <td class="text-end"><?php echo e($order->order_date ? Carbon::parse($order->order_date)->format('d/m/Y') : '-'); ?></td>
                            </tr>
                            <tr>
                                <td class="text-muted">Kho xuất:</td>
                                <td class="text-end"><a href="#" class="text-decoration-none"><?php echo e($order->warehouse->name ?? 'N/A'); ?></a></td>
                            </tr>
                            <tr>
                                <td class="text-muted">Người tạo:</td>
                                <td class="text-end"><?php echo e($order->creator->name ?? 'N/A'); ?></td>
                            </tr>
                            <?php if($order->approved_by): ?>
                                <tr class="border-top">
                                    <td class="text-muted pt-2">Duyệt cuối:</td>
                                    <td class="text-end pt-2 fw-bold text-success"><?php echo e($order->approver->name ?? 'N/A'); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Ngày duyệt:</td>
                                    <td class="text-end"><?php echo e($order->approved_at ? Carbon::parse($order->approved_at)->format('d/m/Y H:i') : '-'); ?></td>
                                </tr>
                            <?php endif; ?>
                        </table>
                    </div>
                </div>

                
                <?php if(isset($notifications) && $notifications->count() > 0 && Auth::id() == $order->created_by): ?>
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-warning text-dark fw-bold">
                            <i class="bi bi-bell"></i> Thông báo mới
                        </div>
                        <div class="list-group list-group-flush">
                            <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notif): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="list-group-item list-group-item-action <?php echo e($notif->is_read ? 'bg-light' : ''); ?>">
                                    <div class="d-flex w-100 justify-content-between">
                                        <strong class="mb-1 text-truncate" style="max-width: 200px;"><?php echo e($notif->title); ?></strong>
                                        <small class="text-muted"><?php echo e($notif->created_at->diffForHumans()); ?></small>
                                    </div>
                                    <p class="mb-1 small"><?php echo e($notif->message); ?></p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

                
                <div class="card shadow-sm sticky-top" style="top: 20px;">
                    <div class="card-header bg-secondary text-white fw-bold">
                        <i class="bi bi-gear"></i> Bảng điều khiển
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recordPayment', $order)): ?>
                                <button class="btn btn-outline-success text-start" data-bs-toggle="modal" data-bs-target="#paymentModal">
                                    <i class="bi bi-cash-coin me-2"></i> Ghi nhận thanh toán
                                </button>
                            <?php endif; ?>

                            
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ship', $order)): ?>
                                <button class="btn btn-outline-primary text-start" data-bs-toggle="modal" data-bs-target="#shipModal">
                                    <i class="bi bi-box-seam-fill me-2"></i> Xác nhận xuất kho
                                </button>
                            <?php endif; ?>

                            
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $order)): ?>
                                <hr class="my-2">
                                <form action="<?php echo e(route('orders.destroy', $order->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger w-100"
                                            onclick="return confirm('CẢNH BÁO: Hành động này không thể hoàn tác.\nBạn có chắc chắn muốn hủy đơn hàng này?')">
                                        <i class="bi bi-trash3 me-2"></i> Hủy đơn hàng
                                    </button>
                                </form>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="paymentModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="<?php echo e(route('orders.record-payment', $order->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header bg-success text-white">
                        <h5 class="modal-title"><i class="bi bi-cash"></i> Ghi nhận thanh toán</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-light border">
                            Tổng tiền đơn hàng: <strong><?php echo e(number_format($order->total_amount)); ?> đ</strong><br>
                            Đã thanh toán: <strong class="text-success"><?php echo e(number_format($order->payments->sum('amount'))); ?> đ</strong><br>
                            Còn nợ: <strong class="text-danger"><?php echo e(number_format($order->total_amount - $order->payments->sum('amount'))); ?> đ</strong>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Ngày thanh toán</label>
                            <input type="date" name="payment_date" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Số tiền thực nhận</label>
                            <div class="input-group">
                                <input type="number" name="amount" class="form-control" step="1000"
                                       value="<?php echo e($order->total_amount - $order->payments->sum('amount')); ?>" required>
                                <span class="input-group-text">VNĐ</span>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Phương thức thanh toán <span class="text-danger">*</span></label>
                            <select name="method_id" class="form-select" required>
                                <option value="">-- Chọn phương thức --</option>
                                
                                <?php if(isset($paymentMethods)): ?>
                                    <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($method->id); ?>"><?php echo e($method->method_name); ?> (<?php echo e($method->code); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Ghi chú giao dịch</label>
                            <textarea name="note" class="form-control" rows="2" placeholder="Mã giao dịch ngân hàng, người nộp tiền..."></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
                        <button type="submit" class="btn btn-success">Lưu thanh toán</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="shipModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="<?php echo e(route('orders.ship', $order->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title"><i class="bi bi-box-seam"></i> Xác nhận xuất kho</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle"></i> Hành động này sẽ trừ tồn kho của <strong><?php echo e($order->items->count()); ?></strong> loại sản phẩm và hoàn tất đơn hàng.
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Ghi chú xuất kho (nếu có)</label>
                            <textarea name="shipping_note" class="form-control" rows="3" placeholder="Thông tin đơn vị vận chuyển, mã vận đơn..."></textarea>
                        </div>

                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" required id="confirmShip">
                            <label class="form-check-label" for="confirmShip">
                                Tôi xác nhận hàng hóa đã sẵn sàng để giao.
                            </label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                        <button type="submit" class="btn btn-primary">Xác nhận xuất</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <style>
        .pulse-animation {
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(25, 135, 84, 0.7); }
            70% { box-shadow: 0 0 0 10px rgba(25, 135, 84, 0); }
            100% { box-shadow: 0 0 0 0 rgba(25, 135, 84, 0); }
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/orders/show.blade.php ENDPATH**/ ?>