<form action="<?php echo e($action); ?>" method="POST" class="mt-3">
    <?php echo csrf_field(); ?>
    <?php if($method === 'PUT'): ?>
        <?php echo method_field('PUT'); ?>
    <?php endif; ?>

    <div class="mb-3">
        <label>Name</label>
        <input class="form-control"
               type="text"
               name="name"
               value="<?php echo e(old('name', $user->name ?? '')); ?>"
               required>
    </div>

    <div class="mb-3">
        <label>Email</label>
        <input class="form-control"
               type="email"
               name="email"
               value="<?php echo e(old('email', $user->email ?? '')); ?>"
               required>
    </div>

    <div class="mb-3">
        <label>Password</label>
        <input class="form-control"
               type="password"
               name="password"
                <?php echo e($user ? '' : 'required'); ?>>
        <?php if($user): ?>
            <small class="text-muted">(Để trống nếu không đổi mật khẩu)</small>
        <?php endif; ?>
    </div>

    <div class="mb-3">
        <label>Confirm Password</label>
        <input class="form-control"
               type="password"
               name="password_confirmation"
                <?php echo e($user ? '' : 'required'); ?>>
    </div>

    <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
    <div class="mb-3">
        <label>Roles</label>
        <select name="roles[]" class="form-control" multiple>
            <?php $__currentLoopData = \Spatie\Permission\Models\Role::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($role->name); ?>"
                        <?php if($user && $user->hasRole($role->name)): ?> selected <?php endif; ?>>
                    <?php echo e($role->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <?php endif; ?>

    <button class="btn btn-success">Save</button>
</form>
<?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/users/_form.blade.php ENDPATH**/ ?>