<form action="<?php echo e($action); ?>" method="POST" class="mt-3">
    <?php echo csrf_field(); ?>
    <?php if($method === 'PUT'): ?>
        <?php echo method_field('PUT'); ?>
    <?php endif; ?>

    <div class="mb-3">
        <label for="warehouse-name" class="form-label">Tên kho</label>
        <input
            id="warehouse-name"
            class="form-control"
            type="text"
            name="name"
            value="<?php echo e(old('name', $warehouse->name ?? '')); ?>"
            required
        >
    </div>

    <div class="mb-3">
        <label for="warehouse-location" class="form-label">Địa điểm</label>
        <input
            id="warehouse-location"
            class="form-control"
            type="text"
            name="location"
            value="<?php echo e(old('location', $warehouse->location ?? '')); ?>"
        >
    </div>

    <button type="submit" class="btn btn-success">
        <?php echo e($method === 'PUT' ? 'Cập nhật' : 'Tạo mới'); ?>

    </button>
</form>

<?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/warehouses/_form.blade.php ENDPATH**/ ?>