
<?php $__env->startSection('title', 'Danh sách đơn hàng'); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h1 class="fw-bold text-uppercase text-secondary">DANH SÁCH ĐƠN HÀNG</h1>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\CRM\Order::class)): ?>
                <a href="<?php echo e(route('orders.create')); ?>" class="btn btn-primary">
                    <i class="bi bi-plus-lg"></i> Tạo đơn mới
                </a>
            <?php endif; ?>
        </div>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <i class="bi bi-check-circle"></i> <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        
        <form action="<?php echo e(route('orders.index')); ?>" method="GET" class="mb-3">
            <div class="card shadow-sm">
                <div class="card-body">
                    <div class="row g-2 align-items-end">
                        <div class="col-md-3">
                            <label class="form-label small">Tìm kiếm</label>
                            <input type="text" name="search" class="form-control form-control-sm"
                                   value="<?php echo e(request('search')); ?>"
                                   placeholder="Mã đơn, tên khách...">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label small">Trạng thái</label>
                            <select name="status" class="form-select form-select-sm">
                                <option value="">-- Tất cả --</option>
                                <option value="sales" <?php echo e(request('status') == 'sales' ? 'selected' : ''); ?>>Chờ gửi duyệt</option>
                                <option value="ketoan" <?php echo e(request('status') == 'ketoan' ? 'selected' : ''); ?>>Chờ kế toán</option>
                                <option value="duyet1" <?php echo e(request('status') == 'duyet1' ? 'selected' : ''); ?>>Chờ duyệt cấp 1</option>
                                <option value="duyet2" <?php echo e(request('status') == 'duyet2' ? 'selected' : ''); ?>>Chờ giám đốc</option>
                                <option value="kho" <?php echo e(request('status') == 'kho' ? 'selected' : ''); ?>>Chờ xuất kho</option>
                                <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>Hoàn tất</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label small">Từ ngày</label>
                            <input type="date" name="from_date" class="form-control form-control-sm"
                                   value="<?php echo e(request('from_date')); ?>">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label small">Đến ngày</label>
                            <input type="date" name="to_date" class="form-control form-control-sm"
                                   value="<?php echo e(request('to_date')); ?>">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label small">Kho</label>
                            <select name="warehouse_id" class="form-select form-select-sm">
                                <option value="">-- Tất cả --</option>
                                <?php $__currentLoopData = $warehouses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wh): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($wh->id); ?>" <?php echo e(request('warehouse_id') == $wh->id ? 'selected' : ''); ?>>
                                        <?php echo e($wh->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button type="submit" class="btn btn-primary btn-sm w-100">
                                <i class="bi bi-search"></i> Lọc
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>

        
        <div class="table-responsive shadow-sm">
            <table class="table table-striped table-bordered align-middle table-hover">
                <thead class="table-dark small text-center">
                <tr>
                    <th style="width: 5%">#</th>
                    <th style="width: 12%">Mã đơn</th>
                    <th style="width: 10%">Ngày đặt</th>
                    <th style="width: 18%">Khách hàng</th>
                    <th style="width: 10%">Tổng tiền</th>
                    <th style="width: 12%">Trạng thái</th>
                    <th style="width: 12%">Bộ phận hiện tại</th>
                    <th style="width: 11%">Người tạo</th>
                    <th style="width: 10%">Thao tác</th>
                </tr>
                </thead>
                <tbody class="small">
                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td class="text-center"><?php echo e($loop->iteration); ?></td>
                        <td>
                            <a href="<?php echo e(route('orders.show', $order->id)); ?>" class="text-decoration-none fw-bold">
                                <?php echo e($order->order_code); ?>

                            </a>
                        </td>
                        <td class="text-center"><?php echo e($order->order_date ? \Carbon\Carbon::parse($order->order_date)->format('d/m/Y') : '-'); ?></td>
                        <td>
                            <div class="fw-semibold"><?php echo e($order->lead->customer->name); ?></div>
                            <small class="text-muted"><?php echo e($order->lead->customer->phone); ?></small>
                        </td>
                        <td class="text-end">
                            <span class="fw-bold text-primary"><?php echo e(number_format($order->total_amount, 0, ',', '.')); ?> đ</span>
                        </td>
                        <td class="text-center">
                        <span class="badge" style="background-color: <?php echo e($order->currentStatusType->color ?? '#6c757d'); ?>">
                            <?php echo e($order->currentStatusType->name ?? 'N/A'); ?>

                        </span>
                        </td>
                        <td class="text-center">
                            <?php
                                $deptBadges = [
                                    'sales' => 'secondary',
                                    'ketoan' => 'info',
                                    'duyet1' => 'warning',
                                    'duyet2' => 'primary',
                                    'kho' => 'dark',
                                    'completed' => 'success'
                                ];
                                $badgeClass = $deptBadges[$order->current_department] ?? 'secondary';
                            ?>
                            <span class="badge bg-<?php echo e($badgeClass); ?>">
                            <?php echo e(ucfirst($order->current_department)); ?>

                        </span>
                        </td>
                        <td><?php echo e($order->creator->name ?? 'N/A'); ?></td>
                        <td class="text-center">
                            <div class="btn-group btn-group-sm">
                                <a href="<?php echo e(route('orders.show', $order->id)); ?>"
                                   class="btn btn-outline-info" title="Xem chi tiết">
                                    <i class="bi bi-eye"></i>
                                </a>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $order)): ?>
                                    <a href="<?php echo e(route('orders.edit', $order->id)); ?>"
                                       class="btn btn-outline-warning" title="Sửa">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('approve', $order)): ?>
                                    <a href="<?php echo e(route('orders.approval-form', $order->id)); ?>"
                                       class="btn btn-outline-success" title="Duyệt">
                                        <i class="bi bi-check-circle"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="9" class="text-center text-muted py-4">
                            Không có đơn hàng nào.
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

        
        <div class="mt-3">
            <?php echo e($orders->links('pagination::bootstrap-5')); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/orders/index.blade.php ENDPATH**/ ?>