<?php
    $isEdit = isset($customer);
    $action = $isEdit
        ? route('customers.update', $customer->id)
        : route('customers.store');
?>
<div class="modal-header">
    <h5 class="modal-title">
        <?php echo e($isEdit ? 'Cập nhật khách hàng' : 'Thêm mới khách hàng'); ?>

    </h5>
    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<form method="POST" action="<?php echo e($action); ?>">
    <?php echo csrf_field(); ?>
    <?php if($isEdit): ?> <?php echo method_field('PUT'); ?> <?php endif; ?>
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Tên khách *</label>
                <input type="text" name="name" class="form-control"
                       value="<?php echo e(old('name', $customer->name ?? '')); ?>" required>
            </div>
            <div class="col-md-6">
                <label class="form-label">Số điện thoại</label>
                <input type="text" name="phone" class="form-control"
                       value="<?php echo e(old('phone', $customer->phone ?? '')); ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">Tên Facebook</label>
                <input type="text" name="facebook_name" class="form-control"
                       value="<?php echo e(old('facebook_name', $customer->facebook_name ?? '')); ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">Link Facebook</label>
                <input type="url" name="facebook_link" class="form-control"
                       value="<?php echo e(old('facebook_link', $customer->facebook_link ?? '')); ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">Zalo ID</label>
                <input type="text" name="zalo_id" class="form-control"
                       value="<?php echo e(old('zalo_id', $customer->zalo_id ?? '')); ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">Email</label>
                <input type="email" name="email" class="form-control"
                       value="<?php echo e(old('email', $customer->email ?? '')); ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">Loại khách</label>
                <select name="customer_type_id" class="form-select">
                    <option value="">-- Chọn --</option>
                    <?php $__currentLoopData = $customerTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($ct->id); ?>"
                                <?php echo e(old('customer_type_id', $customer->customer_type_id ?? '') == $ct->id ? 'selected' : ''); ?>>
                            <?php echo e($ct->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-6">
                <label class="form-label">Trạng thái</label>
                <select name="customer_status" class="form-select">
                    <option value="lead" <?php echo e(old('customer_status', $customer->customer_status ?? 'lead') == 'lead' ? 'selected' : ''); ?>>Lead</option>
                    <option value="member" <?php echo e(old('customer_status', $customer->customer_status ?? '') == 'member' ? 'selected' : ''); ?>>Member</option>
                </select>
            </div>
            <div class="col-md-6">
                <label class="form-label">Khu vực</label>
                <select name="region_id" class="form-select">
                    <option value="">-- Chọn khu vực --</option>
                    <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($r->id); ?>"
                                <?php echo e(old('region_id', $customer->region_id ?? '') == $r->id ? 'selected' : ''); ?>>
                            <?php echo e($r->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-6">
                <label class="form-label">Nguồn (từ Lead)</label>
                <select name="source_id" class="form-select" disabled>
                    <option>-- Xem từ Lead liên kết --</option>
                </select>
                <small class="text-muted">Lấy từ bảng crm_leads</small>
            </div>
            <div class="col-12">
                <label class="form-label">Địa chỉ</label>
                <textarea name="address" class="form-control"><?php echo e(old('address', $customer->address ?? '')); ?></textarea>
            </div>
            <div class="col-md-6">
                <label class="form-label">Biệt danh</label>
                <input type="text" name="nickname" class="form-control"
                       value="<?php echo e(old('nickname', $customer->nickname ?? '')); ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">Ghi chú nhóm</label>
                <input type="text" name="group_note" class="form-control"
                       value="<?php echo e(old('group_note', $customer->group_note ?? '')); ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">Đánh giá</label>
                <select name="is_potential" class="form-select">
                    <option value="0" <?php echo e(old('is_potential', $customer->is_potential ?? 0) == 0 ? 'selected' : ''); ?>>Không</option>
                    <option value="1" <?php echo e(old('is_potential', $customer->is_potential ?? 0) == 1 ? 'selected' : ''); ?>>Có (Tiềm năng)</option>
                </select>
                <small class="text-muted">Đánh dấu khách hàng tiềm năng</small>
            </div>
            <div class="col-md-6">
                <label class="form-label">Ghi chú (từ Lead)</label>
                <input type="text" class="form-control" disabled placeholder="-- Xem từ Lead liên kết --">
                <small class="text-muted">Lấy từ bảng crm_leads</small>
            </div>
            <div class="col-md-6">
                <label class="form-label">Người phụ trách</label>
                <select name="owner_id" class="form-select">
                    <option value="">-- Chọn --</option>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($u->id); ?>"
                                <?php echo e(old('owner_id', $customer->owner_id ?? '') == $u->id ? 'selected' : ''); ?>>
                            <?php echo e($u->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-12">
                <label class="form-label">Ghi chú marketing (từ Lead)</label>
                <textarea name="marketing_note_info" class="form-control" rows="3" disabled placeholder="-- Xem từ Lead liên kết --"></textarea>
                <small class="text-muted">Lấy từ bảng crm_leads</small>
            </div>
        </div>
    <div class="modal-footer">
        <button class="btn btn-primary">
            <?php echo e($isEdit ? 'Cập nhật' : 'Thêm mới'); ?>

        </button>
    </div>
</form>
</div><?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/customers/_form.blade.php ENDPATH**/ ?>