
<?php $__env->startSection('title', 'Tạo đơn hàng mới'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h1 class="fw-bold text-uppercase text-secondary">TẠO ĐƠN HÀNG MỚI</h1>
            <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Quay lại
            </a>
        </div>

        










        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        
        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <strong>Có lỗi xảy ra:</strong>
                <ul class="mb-0 mt-2">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('orders.store')); ?>"
              method="POST"
              id="orderForm"
              onsubmit="console.log('Form submitting...'); return true;">
            <?php echo csrf_field(); ?>

            
            <?php if(config('app.debug')): ?>
                <input type="hidden" name="_debug" value="1">
            <?php endif; ?>

            <div class="row">
                <div class="col-md-8">
                    <?php echo $__env->make('orders.partials.order-info', ['customers' => $customers, 'warehouses' => $warehouses], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php echo $__env->make('orders.partials.product-table', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>

                <div class="col-md-4">
                    <?php echo $__env->make('orders.partials.order-summary', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </div>
        </form>
    </div>

    <?php $__env->startSection('scripts'); ?>
        <script>
            // Debug logging
            console.log('Order create page loaded');
            console.log('Form action:', document.getElementById('orderForm').action);
            console.log('CSRF token present:', document.querySelector('input[name="_token"]') !== null);

            // Intercept form submission for debugging
            document.getElementById('orderForm').addEventListener('submit', function(e) {
                console.log('=== FORM SUBMIT DEBUG ===');

                const formData = new FormData(this);
                const data = {};
                formData.forEach((value, key) => {
                    data[key] = value;
                });

                console.log('Form data:', data);
                console.log('Action URL:', this.action);
                console.log('Method:', this.method);

                // Check required fields
                const requiredFields = ['customer_id', 'lead_id', 'order_date', 'warehouse_id'];
                const missing = requiredFields.filter(field => !formData.get(field));

                if (missing.length > 0) {
                    console.error('Missing required fields:', missing);
                    alert('Thiếu các trường bắt buộc: ' + missing.join(', '));
                    e.preventDefault();
                    return false;
                }

                // Check items
                const hasItems = formData.has('items[0][product_id]');
                if (!hasItems) {
                    console.error('No items found');
                    alert('Vui lòng thêm ít nhất một sản phẩm');
                    e.preventDefault();
                    return false;
                }

                console.log('Validation passed, submitting...');

                // Allow form to submit
                return true;
            });

            // Listen for page unload to detect redirect
            window.addEventListener('beforeunload', function() {
                console.log('Page unloading (redirect or refresh)');
            });
        </script>

        <script src="<?php echo e(asset('js/order-form.js')); ?>"></script>
    <?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/orders/create.blade.php ENDPATH**/ ?>