

<?php $__env->startSection('title', 'Dashboard CRM'); ?>

<?php $__env->startSection('content'); ?>

	<style>
		/* DARK MODE */
		body.dark-mode {
			background: #1e1e1e;
			color: #ddd;
		}
		body.dark-mode .card {
			background: #2b2b2b;
			color: #fff !important;
		}
		body.dark-mode table {
			color: #fff !important;
		}
	</style>

	<div class="container-fluid">

		
		<div class="d-flex justify-content-between align-items-center mb-4">
			<h1 class="fw-bold">📊 Tổng quan CRM</h1>

			<button id="darkModeToggle" class="btn btn-dark">
				🌙 Dark Mode
			</button>
		</div>

		
		<form action="<?php echo e(route('dashboard')); ?>" method="GET" class="mb-4">
			<div class="row g-2 align-items-end">
				<div class="col-md-3">
					<label>Từ ngày</label>
					<input type="date" name="from" value="<?php echo e(request('from')); ?>" class="form-control">
				</div>
				<div class="col-md-3">
					<label>Đến ngày</label>
					<input type="date" name="to" value="<?php echo e(request('to')); ?>" class="form-control">
				</div>
				<div class="col-md-3">
					<label>Theo kỳ</label>
					<select name="period" class="form-select">
						<option value="">-- Tuỳ chọn --</option>
						<option value="7days"  <?php echo e(request('period')=='7days'?'selected':''); ?>>7 ngày gần nhất</option>
						<option value="30days" <?php echo e(request('period')=='30days'?'selected':''); ?>>30 ngày gần nhất</option>
						<option value="month"  <?php echo e(request('period')=='month'?'selected':''); ?>>Tháng này</option>
						<option value="year"   <?php echo e(request('period')=='year'?'selected':''); ?>>Năm nay</option>
					</select>
				</div>

				<div class="col-md-3">
					<button class="btn btn-primary w-100">Lọc dữ liệu</button>
				</div>
			</div>
		</form>

		
		<div class="row g-4 mb-4">
			<div class="col-md-3">
				<div class="card p-3 text-center shadow-sm">
					<h6 class="text-muted">Tổng khách hàng</h6>
					<h2 class="fw-bold"><?php echo e($total_customers); ?></h2>
				</div>
			</div>

			<div class="col-md-3">
				<div class="card p-3 text-center shadow-sm">
					<h6 class="text-muted">Khách có mua hàng</h6>
					<h2 class="fw-bold"><?php echo e($total_customers_buy); ?></h2>
				</div>
			</div>

			<div class="col-md-3">
				<div class="card p-3 text-center shadow-sm">
					<h6 class="text-muted">Lead</h6>
					<h2 class="fw-bold"><?php echo e($total_leads); ?></h2>
				</div>
			</div>

			<div class="col-md-3">
				<div class="card p-3 text-center shadow-sm">
					<h6 class="text-muted">Đơn hàng</h6>
					<h2 class="fw-bold"><?php echo e($total_orders); ?></h2>
				</div>
			</div>
		</div>

		
		<div class="row mb-4">
			<div class="col-md-12">
				<div class="card p-3 text-center shadow-sm">
					<h6 class="text-muted">Tổng thanh toán</h6>
					<h2 class="fw-bold text-success"><?php echo e(number_format($total_payments)); ?> đ</h2>
				</div>
			</div>
		</div>

		
		<div class="row g-4 mb-4">
			<div class="col-md-6">
				<div class="card p-3 shadow-sm">
					<h5 class="fw-bold">📈 Doanh thu theo tháng</h5>
					<canvas id="revenueChart"></canvas>
				</div>
			</div>

			<div class="col-md-6">
				<div class="card p-3 shadow-sm">
					<h5 class="fw-bold">🔥 TOP nhân viên Sales theo doanh thu</h5>
					<canvas id="topSalesChart"></canvas>
				</div>
			</div>
		</div>

		
		<div class="row g-4 mb-4">
			<div class="col-md-4">
				<div class="card p-3 shadow-sm">
					<h5 class="fw-bold">🎯 Tỉ lệ khách mua</h5>
					<canvas id="customerPie"></canvas>
				</div>
			</div>

			<div class="col-md-4">
				<div class="card p-3 shadow-sm">
					<h5 class="fw-bold">📣 Tỉ lệ nguồn Lead</h5>
					<canvas id="leadSourcePie"></canvas>
				</div>
			</div>

			<div class="col-md-4">
				<div class="card p-3 shadow-sm">
					<h5 class="fw-bold">📑 Tỉ lệ trạng thái đơn hàng</h5>
					<canvas id="orderStatusPie"></canvas>
				</div>
			</div>
		</div>

		
		<div class="card p-3 shadow-sm mb-4">
			<h5 class="fw-bold">🔥 Top nhân viên bán hàng</h5>
			<table class="table table-hover">
				<thead>
				<tr>
					<th>Nhân viên</th>
					<th class="text-end">Doanh thu</th>
				</tr>
				</thead>
				<tbody>
				<?php $__currentLoopData = $top_sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr>
						<td><?php echo e($s->name); ?></td>
						<td class="text-end"><?php echo e(number_format($s->revenue)); ?> đ</td>
					</tr>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</tbody>
			</table>
		</div>

	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

	<script>
		/* ---------------- DARK MODE ------------------- */
		document.getElementById('darkModeToggle').addEventListener('click', function () {
			document.body.classList.toggle('dark-mode');
		});

		/* ---------------- LINE: Revenue ------------------- */
		new Chart(document.getElementById('revenueChart'), {
			type: "line",
			data: {
				labels: <?php echo json_encode($revenue_by_month->pluck('month')); ?>,
				datasets: [{
					label: "Doanh thu",
					data: <?php echo json_encode($revenue_by_month->pluck('revenue')); ?>,
					borderWidth: 3,
					borderColor: "#0d6efd"
				}]
			}
		});

		/* ---------------- BAR: Orders ------------------- */
		
		
		
		
		
		
		
		
		
		
		
		new Chart(document.getElementById('topSalesChart'), {
			type: "bar",
			data: {
				labels: <?php echo json_encode($top_sales->pluck('name')); ?>,
				datasets: [{
					label: "Doanh thu",
					data: <?php echo json_encode($top_sales->pluck('revenue')); ?>,
					backgroundColor: "#198754"
				}]
			},
			options: {
				responsive: true,
				plugins: {
					legend: { display: false },
					tooltip: { mode: 'index', intersect: false }
				},
				scales: {
					y: {
						beginAtZero: true,
						ticks: {
							callback: function(value) {
								return value.toLocaleString() + ' đ';
							}
						}
					}
				}
			}
		});
		/* ---------------- PIE: Customer Purchase Ratio ------------------- */
		new Chart(document.getElementById('customerPie'), {
			type: "doughnut",
			data: {
				labels: ["Có mua", "Chưa mua"],
				datasets: [{
					data: [<?php echo e($total_customers_buy); ?>, <?php echo e($total_customers - $total_customers_buy); ?>],
				}]
			}
		});

		/* ---------------- PIE: Lead Source ------------------- */
		new Chart(document.getElementById('leadSourcePie'), {
			type: "pie",
			data: {
				labels: <?php echo json_encode($lead_sources->pluck('source_name')); ?>,
				datasets: [{
					data: <?php echo json_encode($lead_sources->pluck('total')); ?>

				}]
			}
		});

		/* ---------------- PIE: Order Status ------------------- */
		new Chart(document.getElementById('orderStatusPie'), {
			type: "pie",
			data: {
				labels: <?php echo json_encode($order_status_chart->pluck('status')); ?>,
				datasets: [{
					data: <?php echo json_encode($order_status_chart->pluck('total')); ?>

				}]
			}
		});
	</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/dashboard/index.blade.php ENDPATH**/ ?>