
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h1 class="fw-bold text-uppercase text-secondary">Danh sách sản phẩm</h1>
            <a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary">Thêm sản phẩm</a>
        </div>
        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        <div class="table-responsive shadow-sm">
            <table class="table table-striped table-bordered align-middle table-hover text-center">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Tên</th>
                    <th>Mã SKU</th>
                    <th>Giá đại lý</th>
                    <th>Giá bán lẻ</th>
                    <th>Số lượng</th>
                    <th>Danh mục</th>
                    <th>Hình ảnh</th>
                    <th width="140">Hành động</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($p->id); ?></td>
                        <td><?php echo e($p->name); ?></td>
                        <td><?php echo e($p->sku); ?></td>
                        <td><?php echo e(number_format($p->price_agent)); ?></td>
                        <td><?php echo e(number_format($p->price_retail)); ?></td>
                        <td><?php echo e(number_format($p->stocks->sum('qty'))); ?></td>
                        <td><?php echo e($p->category?->name); ?></td>
                        <td>
                            <?php
                                $mainMedia = optional($p->mainImage)->media;
                                $imageUrl = $mainMedia?->metadata->url ?? ($mainMedia?->file_path ? Storage::disk('public')->url($mainMedia->file_path) : null);
                            ?>
                            <?php if($imageUrl): ?>
                                <img src="<?php echo e($imageUrl); ?>"
                                     alt="<?php echo e($p->name); ?>"
                                     width="50"
                                     class="rounded">
                            <?php else: ?>
                                <span class="text-muted">Không có</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?php echo e(route('products.edit', $p->id)); ?>"
                               class="btn btn-sm btn-outline-warning">
                                Sửa
                            </a>
                            <form action="<?php echo e(route('products.destroy', $p->id)); ?>"
                                  method="POST"
                                  class="d-inline-block">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-sm btn-outline-danger"
                                        onclick="return confirm('Bạn chắc chắn muốn xóa?')">
                                    Xóa
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php echo e($products->links()); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/products/index.blade.php ENDPATH**/ ?>