<?php $__env->startSection('title', 'Chi tiết khách hàng'); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h1 class="fw-bold text-uppercase text-secondary">CHI TIẾT KHÁCH HÀNG</h1>
            <div>
                <a href="<?php echo e(route('customers.edit', $customer->id)); ?>" class="btn btn-warning">
                    <i class="bi bi-pencil"></i> Sửa
                </a>
                <a href="<?php echo e(route('customers.index')); ?>" class="btn btn-secondary">
                    <i class="bi bi-arrow-left"></i> Quay lại
                </a>
            </div>
        </div>

        <div class="row">
            
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Thông tin cơ bản</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tr>
                                <th width="40%">Tên khách hàng:</th>
                                <td><?php echo e($customer->name); ?></td>
                            </tr>
                            <tr>
                                <th>Biệt danh:</th>
                                <td><?php echo e($customer->nickname ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Số điện thoại:</th>
                                <td><?php echo e($customer->phone ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Email:</th>
                                <td><?php echo e($customer->email ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Địa chỉ:</th>
                                <td><?php echo e($customer->address ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Khu vực:</th>
                                <td><?php echo e($customer->region->name ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Loại khách:</th>
                                <td><?php echo e($customer->customerType->name ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Trạng thái:</th>
                                <td>
                                    <span class="badge <?php echo e($customer->customer_status == 'member' ? 'bg-success' : 'bg-warning'); ?>">
                                        <?php echo e($customer->customer_status == 'member' ? 'Hội viên' : 'Lead'); ?>

                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <th>Đánh giá:</th>
                                <td>
                                    <?php if($customer->is_potential): ?>
                                        <span class="badge bg-info">⭐ Tiềm năng</span>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

            
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">Thông tin liên hệ</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tr>
                                <th width="40%">Facebook:</th>
                                <td>
                                    <?php if($customer->facebook_link): ?>
                                        <a href="<?php echo e($customer->facebook_link); ?>" target="_blank"><?php echo e($customer->facebook_name ?? 'Link'); ?></a>
                                    <?php else: ?>
                                        <?php echo e($customer->facebook_name ?? '-'); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Zalo ID:</th>
                                <td><?php echo e($customer->zalo_id ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Người phụ trách:</th>
                                <td><?php echo e($customer->assignedUser->name ?? 'Chưa gán'); ?></td>
                            </tr>
                            <tr>
                                <th>Ghi chú nhóm:</th>
                                <td><?php echo e($customer->group_note ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Ngày tạo:</th>
                                <td><?php echo e($customer->created_at?->format('d/m/Y H:i')); ?></td>
                            </tr>
                            <tr>
                                <th>Người tạo:</th>
                                <td><?php echo e($customer->creator->name ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Cập nhật lần cuối:</th>
                                <td><?php echo e($customer->updated_at?->format('d/m/Y H:i')); ?></td>
                            </tr>
                            <?php if($customer->converted_to_member_at): ?>
                            <tr>
                                <th>Chuyển thành hội viên:</th>
                                <td><?php echo e($customer->converted_to_member_at->format('d/m/Y H:i')); ?></td>
                            </tr>
                            <?php endif; ?>
                        </table>
                    </div>
                </div>
            </div>

            
            <?php if($customer->latestLead): ?>
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-warning text-dark">
                        <h5 class="mb-0">Lead mới nhất</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tr>
                                <th width="40%">Ngày liên hệ:</th>
                                <td><?php echo e($customer->latestLead->contact_date ? \Carbon\Carbon::parse($customer->latestLead->contact_date)->format('d/m/Y') : '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Nguồn:</th>
                                <td><?php echo e($customer->latestLead->source->name ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Trạng thái:</th>
                                <td><?php echo e($customer->latestLead->status->name ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Ghi chú:</th>
                                <td><?php echo e($customer->latestLead->note ?? '-'); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            
            <?php if($customer->latestOrder): ?>
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">Đơn hàng mới nhất</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tr>
                                <th width="40%">Mã đơn:</th>
                                <td><?php echo e($customer->latestOrder->order_code); ?></td>
                            </tr>
                            <tr>
                                <th>Ngày đặt:</th>
                                <td><?php echo e($customer->latestOrder->order_date ? \Carbon\Carbon::parse($customer->latestOrder->order_date)->format('d/m/Y') : '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Tổng tiền:</th>
                                <td><?php echo e(number_format($customer->latestOrder->total_amount, 0, ',', '.')); ?> đ</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>

        
        <?php if($customer->leads && $customer->leads->count() > 0): ?>
        <div class="card shadow-sm mb-4">
            <div class="card-header">
                <h5 class="mb-0">Lịch sử Leads (<?php echo e($customer->leads->count()); ?>)</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Ngày liên hệ</th>
                                <th>Nguồn</th>
                                <th>Trạng thái</th>
                                <th>Ghi chú</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $customer->leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($lead->contact_date ? \Carbon\Carbon::parse($lead->contact_date)->format('d/m/Y') : '-'); ?></td>
                                <td><?php echo e($lead->source->name ?? '-'); ?></td>
                                <td><?php echo e($lead->status->name ?? '-'); ?></td>
                                <td><?php echo e(Str::limit($lead->note, 50)); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/customers/show.blade.php ENDPATH**/ ?>