<?php use Illuminate\Support\Facades\Storage; ?>
<?php echo csrf_field(); ?>
<?php
    $productInstance = $product ?? null;
    $selectedWarehouse = $formData['selectedWarehouse'] ?? null;
    $currentQuantity = $formData['currentQuantity'] ?? 0;
    $defaultQuantity = $formData['defaultQuantity'] ?? null;
    $existingGallery = $formData['existingGallery'] ?? collect();
    $defaultGalleryIds = $formData['defaultGalleryIds'] ?? '';
?>

<div class="mb-3">
    <label class="form-label">Tên sản phẩm</label>
    <input type="text" name="name" class="form-control"
           value="<?php echo e(old('name', $product->name ?? '')); ?>" required>
</div>

<div class="mb-3">
    <label class="form-label">Mã SKU</label>
    <input type="text" name="sku" class="form-control"
           value="<?php echo e(old('sku', $product->sku ?? '')); ?>" required>
</div>

<div class="row">
    <div class="col-md-6 mb-3">
        <label class="form-label">Giá đại lý</label>
        <input type="number" step="0.01" name="price_agent" class="form-control"
               value="<?php echo e(old('price_agent', $product->price_agent ?? 0)); ?>" required>
    </div>
    <div class="col-md-6 mb-3">
        <label class="form-label">Giá bán lẻ</label>
        <input type="number" step="0.01" name="price_retail" class="form-control"
               value="<?php echo e(old('price_retail', $product->price_retail ?? 0)); ?>" required>
    </div>
</div>

<div class="mb-3">
    <label class="form-label">Danh mục</label>
    <select name="category_id" class="form-select">
        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($cat->id); ?>"
                    <?php echo e((string)old('category_id', $product->category_id ?? '') === (string)$cat->id ? 'selected' : ''); ?>>
                <?php echo e($cat->name); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>

<div class="row">
    <div class="col-md-6 mb-3">
        <label class="form-label">Điều chỉnh tồn kho</label>
        <input type="number" name="quantity" min="0" class="form-control"
               value="<?php echo e($defaultQuantity); ?>"
               placeholder="Để trống nếu không thay đổi">
        <small class="text-muted">Giá trị mới áp dụng cho kho được chọn bên cạnh.</small>
    </div>
    <div class="col-md-6 mb-3">
        <label class="form-label">Kho áp dụng</label>
        <select name="warehouse_id" class="form-select">
            <option value="">-- Chọn kho --</option>
            <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $w): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($w->id); ?>" <?php echo e((string)$selectedWarehouse === (string)$w->id ? 'selected' : ''); ?>>
                    <?php echo e($w->name); ?> - <?php echo e($w->location); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <small class="text-muted">Bắt buộc nếu nhập số lượng &gt; 0.</small>
    </div>
</div>

<div class="mb-3">
    <label class="form-label">Tồn kho hiện tại</label>
    <input type="text" class="form-control" value="<?php echo e($currentQuantity); ?>" disabled>
</div>

<div class="mb-3">
    <label class="form-label">Ảnh đại diện</label>
    <button type="button" class="btn btn-outline-secondary" onclick="openMediaModal('main_image', false)">Chọn / Upload</button>
    <input type="hidden" id="main_image_id" name="main_image_id" value="<?php echo e(old('main_image_id', optional(optional($productInstance)->mainImage)->media_id)); ?>">
    <div id="preview_main_image" class="mt-2">
        <?php
            $mainMedia = optional(optional($productInstance)->mainImage)->media;
            $mainImageUrl = $mainMedia?->metadata->url ?? ($mainMedia?->file_path ? Storage::disk('public')->url($mainMedia->file_path) : null);
        ?>
        <?php if($mainImageUrl): ?>
            <img src="<?php echo e($mainImageUrl); ?>" width="150" class="border rounded">
        <?php endif; ?>
    </div>
</div>

<div class="mb-3">
    <label class="form-label">Ảnh gallery</label>
    <button type="button" class="btn btn-outline-secondary" onclick="openMediaModal('gallery', true)">Chọn nhiều</button>
    <input type="hidden" id="gallery_ids" name="gallery_ids" value="<?php echo e($defaultGalleryIds); ?>">
    <div id="preview_gallery" class="mt-2 d-flex flex-wrap gap-2">
        <?php $__currentLoopData = $existingGallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $galleryMedia = $rel->media;
                $galleryUrl = $galleryMedia?->metadata->url ?? ($galleryMedia?->file_path ? Storage::disk('public')->url($galleryMedia->file_path) : null);
            ?>
            <?php if($galleryUrl): ?>
                <img src="<?php echo e($galleryUrl); ?>" width="80" class="border rounded">
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<button class="btn btn-primary"><?php echo e($buttonText); ?></button>
<?php echo $__env->make('media.modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>  
<script>
    <?php if($productInstance): ?>
    // Dữ liệu tồn kho theo kho
    const stockByWarehouse = {
        <?php $__currentLoopData = $productInstance->stocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo e($stock->warehouse_id); ?>: <?php echo e($stock->qty); ?>,
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    };

    // Cập nhật tồn kho hiện tại khi thay đổi kho
    document.querySelector('select[name="warehouse_id"]').addEventListener('change', function() {
        const warehouseId = this.value;
        const currentQtyInput = document.querySelector('input[value="<?php echo e($currentQuantity); ?>"]').parentElement.querySelector('input');

        if (warehouseId && stockByWarehouse[warehouseId] !== undefined) {
            currentQtyInput.value = stockByWarehouse[warehouseId];
        } else {
            currentQtyInput.value = 0;
        }
    });
    <?php endif; ?>
</script><?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/products/_form.blade.php ENDPATH**/ ?>