<nav id="sidebar" class="sidebar bg-dark text-white">
    <div class="sidebar-header d-flex justify-content-between align-items-center p-3 border-bottom border-secondary">
        <h5 class="m-0 text-white">CRM</h5>
        <button id="toggleSidebar" class="btn btn-sm btn-outline-light" title="Thu gọn / Mở rộng">
            <i class="bi bi-list"></i>
        </button>
    </div>

    <ul class="nav flex-column mt-3">
        <li class="nav-item">
            <a href="<?php echo e(route('dashboard')); ?>" class="nav-link text-white <?php echo e(active_route('dashboard')); ?>">
                <i class="bi bi-house-door"></i> <span class="ms-2">Trang chủ</span>
            </a>
        </li>

        <li class="nav-item">
            <a href="#menuKhachHang" class="nav-link text-white <?php echo e(active_route('customers.index')); ?>" data-bs-toggle="collapse" aria-expanded="false">
                <i class="bi-person-lines-fill"></i> <span class="ms-2">Khách hàng</span>
            </a>
            <ul class="collapse list-unstyled ps-4" id="menuKhachHang">
                <li><a href="<?php echo e(route('customers.index')); ?>" class="nav-link text-white <?php echo e(active_route('customers.index')); ?>">Danh sách KH</a></li>
                <li><a href="#" onclick="openCustomerForm()" class="nav-link text-white">Thêm mới</a></li>
            </ul>
        </li>
        <li class="nav-item">
            <a href="#menuOrders" class="nav-link text-white <?php echo e(active_route('orders.index')); ?>" data-bs-toggle="collapse" aria-expanded="false">
                <i class="bi-receipt-cutoff"></i> <span class="ms-2">Đơn hàng</span>
            </a>
            <ul class="collapse list-unstyled ps-4" id="menuOrders">
                <li><a href="<?php echo e(route('orders.index')); ?>" class="nav-link text-white <?php echo e(active_route('orders.index')); ?>">Danh sách</a></li>
                <li><a href="<?php echo e(route('orders.create')); ?>" class="nav-link text-white">Thêm mới</a></li>
                <li><a href="<?php echo e(route('payment-methods.index')); ?>" class="nav-link text-white <?php echo e(active_route('payment-methods.*')); ?>">Phương thức thanh toán</a></li>

            </ul>
        </li>
        <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
        <li class="nav-item">
            <a href="#menuSP" class="nav-link text-white <?php echo e(active_route(['products.*','categories.*','warehouses.*'])); ?>" data-bs-toggle="collapse" aria-expanded="false">
                <i class="bi-box-seam"></i> <span class="ms-2">Sản phẩm</span>
            </a>
            <ul class="collapse list-unstyled ps-4" id="menuSP">
                <li><a href="<?php echo e(route('products.index')); ?>" class="nav-link text-white <?php echo e(active_route('products.index')); ?>">Danh sách sản phẩm</a></li>
                <li><a href="<?php echo e(route('products.create')); ?>" class="nav-link text-white <?php echo e(active_route('products.create')); ?>">Thêm sản phẩm</a></li>
                <li><a href="<?php echo e(route('categories.index')); ?>" class="nav-link text-white <?php echo e(active_route('categories.*')); ?>">Danh mục sản phẩm</a></li>
                <li><a href="<?php echo e(route('warehouses.index')); ?>" class="nav-link text-white <?php echo e(active_route('warehouses.index')); ?>">Danh sách kho</a></li>
            </ul>
        </li>
        <?php endif; ?>

        <li class="nav-item">
            <a href="#menuThongKe" class="nav-link text-white" data-bs-toggle="collapse" aria-expanded="false">
                <i class="bi bi-bar-chart"></i> <span class="ms-2">Thống kê</span>
            </a>
            <ul class="collapse list-unstyled ps-4" id="menuThongKe">
                <li><a href="#" class="nav-link text-white">Tổng kết</a></li>
                <li><a href="#" class="nav-link text-white">Chi tiết</a></li>
            </ul>   
        </li>
        <li class="nav-item">
            <a href="#menuTaiKhoan" class="nav-link text-white <?php echo e(active_route('users.*')); ?>" data-bs-toggle="collapse">
                <i class="bi bi-person-circle"></i> <span class="ms-2">Tài khoản</span>
            </a>
            <ul class="collapse list-unstyled ps-4" id="menuTaiKhoan">

                <li><a href="<?php echo e(route('users.index')); ?>" class="nav-link text-white <?php echo e(active_route('users.index')); ?>">Danh sách User</a></li>
                <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
                    <li><a href="<?php echo e(route('users.create')); ?>" class="nav-link text-white <?php echo e(active_route('users.create')); ?>">Thêm User</a></li>
                <?php endif; ?>
                <li>
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="nav-link text-white bg-transparent border-0">Đăng xuất</button>
                    </form>
                </li>
            </ul>
        </li>
    </ul>
</nav>
<div class="modal fade" id="customerModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content" id="customerModalContent">
            <!-- Content load qua AJAX -->
        </div>
    </div>
</div>
<script>
    async function openCustomerForm(
        url = "<?php echo e(route('customers.popup-form')); ?>"
    ) {
        const modalElement = document.getElementById("customerModal");
        const modalContent = document.getElementById("customerModalContent");

        // Loading state
        modalContent.innerHTML = `
        <div class="p-4 text-center">Đang tải...</div>
    `;

        // Show Bootstrap modal (native)
        const modal = bootstrap.Modal.getOrCreateInstance(modalElement);
        modal.show();

        try {
            const response = await fetch(url, {
                headers: { "X-Requested-With": "XMLHttpRequest" }
            });

            if (!response.ok) throw new Error("Lỗi tải dữ liệu");

            const html = await response.text();
            modalContent.innerHTML = html;

        } catch (err) {
            modalContent.innerHTML = `
            <div class="p-4 text-danger text-center">
                Không thể tải dữ liệu!
            </div>
        `;
            console.error(err);
        }
    }
</script><?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/partials/sidebar.blade.php ENDPATH**/ ?>