<?php $__env->startSection('title', 'Chỉnh sửa đơn hàng #' . $order->order_code); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <h1 class="fw-bold text-uppercase text-secondary">CHỈNH SỬA ĐƠN HÀNG</h1>
                <p class="text-muted mb-0">Mã đơn: <strong><?php echo e($order->order_code); ?></strong></p>
            </div>
            <div>
                <a href="<?php echo e(route('orders.show', $order->id)); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-eye"></i> Xem đơn
                </a>
                <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Quay lại
                </a>
            </div>
        </div>

        
        <?php if($order->current_department !== 'sales'): ?>
            <div class="alert alert-warning">
                <i class="bi bi-exclamation-triangle"></i>
                <strong>Cảnh báo:</strong> Đơn hàng đã được gửi duyệt và không thể chỉnh sửa.
            </div>
        <?php endif; ?>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        
        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <strong>Có lỗi xảy ra:</strong>
                <ul class="mb-0 mt-2">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('orders.update', $order->id)); ?>"
              method="POST"
              id="orderForm">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="row">
                <div class="col-md-8">
                    
                    <div class="card shadow-sm mb-3">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0"><i class="bi bi-bag"></i> Thông tin đơn hàng</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Khách hàng <span class="text-danger">*</span></label>
                                    <select name="customer_id" id="customerSelect" class="form-select" required>
                                        <option value="">-- Chọn khách hàng --</option>
                                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($customer['id']); ?>"
                                                    data-lead-id="<?php echo e($customer['lead_id']); ?>"
                                                    <?php echo e(old('customer_id', $order->lead->customer_id) == $customer['id'] ? 'selected' : ''); ?>>
                                                <?php echo e($customer['display']); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <input type="hidden" name="lead_id" id="leadIdInput"
                                           value="<?php echo e(old('lead_id', $order->lead_id)); ?>">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Ngày đặt hàng <span class="text-danger">*</span></label>
                                    <input type="date"
                                           name="order_date"
                                           class="form-control"
                                           value="<?php echo e(old('order_date', $order->order_date->format('Y-m-d'))); ?>"
                                           required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Kho xuất <span class="text-danger">*</span></label>
                                    <select name="warehouse_id" id="warehouseSelect" class="form-select" required>
                                        <option value="">-- Chọn kho --</option>
                                        <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wh): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($wh['id']); ?>"
                                                    <?php echo e(old('warehouse_id', $order->warehouse_id) == $wh['id'] ? 'selected' : ''); ?>>
                                                <?php echo e($wh['name']); ?> - <?php echo e($wh['location']); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Trạng thái hiện tại</label>
                                    <input type="text"
                                           class="form-control"
                                           value="<?php echo e($order->currentStatusType->name ?? 'N/A'); ?>"
                                           readonly>
                                </div>
                            </div>

                            
                            <div id="customerInfo" class="mt-3 p-3 bg-light rounded">
                                <h6 class="text-primary mb-2"><i class="bi bi-person"></i> Thông tin khách hàng</h6>
                                <div class="row small">
                                    <div class="col-md-6">
                                        <p class="mb-1"><strong>Loại khách:</strong>
                                            <span id="customerType"><?php echo e($order->lead->customer->customerType->name ?? 'N/A'); ?></span>
                                        </p>
                                        <p class="mb-1"><strong>Khu vực:</strong>
                                            <span id="customerRegion"><?php echo e($order->lead->customer->region->name ?? 'N/A'); ?></span>
                                        </p>
                                    </div>
                                    <div class="col-md-6">
                                        <p class="mb-1"><strong>Tổng đơn đã mua:</strong>
                                            <span id="customerOrders"><?php echo e($order->lead->customer->orders->count()); ?></span>
                                        </p>
                                        <p class="mb-1"><strong>Công nợ:</strong>
                                            <span id="customerDebt" class="text-danger">
                                            <?php echo e(number_format($order->lead->customer->unpaidDebts->sum('debt_amount'))); ?> đ
                                        </span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="card shadow-sm">
                        <div class="card-header bg-success text-white d-flex justify-content-between">
                            <h5 class="mb-0"><i class="bi bi-cart"></i> Sản phẩm</h5>
                            <button type="button" class="btn btn-sm btn-light" id="addProductBtn">
                                <i class="bi bi-plus"></i> Thêm sản phẩm
                            </button>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="productTable">
                                    <thead class="table-light">
                                    <tr>
                                        <th style="width: 40%">Sản phẩm</th>
                                        <th style="width: 15%">Đơn giá</th>
                                        <th style="width: 15%">Số lượng</th>
                                        <th style="width: 20%">Thành tiền</th>
                                        <th style="width: 10%"></th>
                                    </tr>
                                    </thead>
                                    <tbody id="productTableBody">
                                    <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="product-row" data-index="<?php echo e($index); ?>">
                                            <td>
                                                <select name="items[<?php echo e($index); ?>][product_id]"
                                                        class="form-select form-select-sm product-select"
                                                        required
                                                        data-index="<?php echo e($index); ?>">
                                                    <option value="">-- Chọn sản phẩm --</option>
                                                    <option value="<?php echo e($item->product_id); ?>"
                                                            data-price="<?php echo e($item->product->price); ?>"
                                                            data-price-agent="<?php echo e($item->product->price_agent); ?>"
                                                            data-price-retail="<?php echo e($item->product->price_retail); ?>"
                                                            selected>
                                                        <?php echo e($item->product->name); ?> (<?php echo e($item->product->sku); ?>)
                                                    </option>
                                                </select>
                                            </td>
                                            <td>
                                                <input type="number"
                                                       name="items[<?php echo e($index); ?>][unit_price]"
                                                       class="form-control form-control-sm text-end unit-price"
                                                       step="0.01"
                                                       value="<?php echo e($item->unit_price); ?>"
                                                       required
                                                       readonly>
                                            </td>
                                            <td>
                                                <input type="number"
                                                       name="items[<?php echo e($index); ?>][quantity]"
                                                       class="form-control form-control-sm text-center quantity"
                                                       min="1"
                                                       value="<?php echo e($item->quantity); ?>"
                                                       required>
                                            </td>
                                            <td>
                                                <input type="text"
                                                       class="form-control form-control-sm text-end line-total"
                                                       value="<?php echo e(number_format($item->quantity * $item->unit_price)); ?> đ"
                                                       readonly>
                                            </td>
                                            <td class="text-center">
                                                <button type="button"
                                                        class="btn btn-sm btn-danger remove-product-btn">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                    <tr class="table-secondary fw-bold">
                                        <td colspan="3" class="text-end">TỔNG CỘNG:</td>
                                        <td class="text-end" id="grandTotal">
                                            <?php echo e(number_format($order->total_amount)); ?> đ
                                        </td>
                                        <td></td>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="col-md-4">
                    <div class="card shadow-sm sticky-top" style="top: 20px;">
                        <div class="card-header bg-warning">
                            <h5 class="mb-0"><i class="bi bi-info-circle"></i> Tóm tắt</h5>
                        </div>
                        <div class="card-body">
                            <table class="table table-sm">
                                <tr>
                                    <td>Mã đơn:</td>
                                    <td class="text-end fw-bold"><?php echo e($order->order_code); ?></td>
                                </tr>
                                <tr>
                                    <td>Tổng sản phẩm:</td>
                                    <td class="text-end fw-bold" id="totalItems"><?php echo e($order->items->count()); ?></td>
                                </tr>
                                <tr>
                                    <td>Tổng số lượng:</td>
                                    <td class="text-end fw-bold" id="totalQuantity"><?php echo e($order->items->sum('quantity')); ?></td>
                                </tr>
                                <tr class="table-primary">
                                    <td>Tổng tiền:</td>
                                    <td class="text-end fw-bold fs-5" id="totalAmount">
                                        <?php echo e(number_format($order->total_amount)); ?> đ
                                    </td>
                                </tr>
                            </table>

                            <hr>

                            <div class="mb-3">
                                <small class="text-muted">
                                    <i class="bi bi-clock-history"></i> Tạo: <?php echo e($order->created_at->format('d/m/Y H:i')); ?><br>
                                    <i class="bi bi-person"></i> Bởi: <?php echo e($order->creator->name); ?>

                                </small>
                            </div>

                            <div class="d-grid gap-2">
                                <?php if($order->current_department === 'sales'): ?>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save"></i> Cập nhật đơn hàng
                                    </button>
                                    <a href="<?php echo e(route('orders.show', $order->id)); ?>"
                                       class="btn btn-outline-secondary">
                                        <i class="bi bi-x"></i> Hủy
                                    </a>
                                <?php else: ?>
                                    <div class="alert alert-warning mb-0 small">
                                        Đơn hàng đã được gửi duyệt và không thể chỉnh sửa.
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    
                    <?php if($order->statusHistory && $order->statusHistory->count() > 0): ?>
                        <div class="card shadow-sm mt-3">
                            <div class="card-header bg-info text-white">
                                <h6 class="mb-0"><i class="bi bi-clock-history"></i> Lịch sử đơn hàng</h6>
                            </div>
                            <div class="card-body">
                                <div class="timeline">
                                    <?php $__currentLoopData = $order->statusHistory->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="timeline-item small mb-2">
                                            <div class="text-muted"><?php echo e($history->changed_at->format('d/m/Y H:i')); ?></div>
                                            <div><?php echo e($history->note); ?></div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        // Set initial state
        let rowIndex = <?php echo e($order->items->count()); ?>;
        let customerTypeId = <?php echo e($order->lead->customer->customer_type_id ?? 'null'); ?>;
        let selectedWarehouseId = <?php echo e($order->warehouse_id); ?>;

        // Reuse the same OrderFormManager from create page
    </script>
    <script src="<?php echo e(asset('js/order-form.js')); ?>?v=<?php echo e(filemtime(public_path('js/order-form.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .timeline-item {
            padding-left: 20px;
            border-left: 2px solid #dee2e6;
            position: relative;
        }

        .timeline-item:before {
            content: '';
            position: absolute;
            left: -5px;
            top: 5px;
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: #0d6efd;
        }

        .timeline-item:last-child {
            border-left-color: transparent;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/lam25/crm-shop.taynguyenweb.com/resources/views/orders/edit.blade.php ENDPATH**/ ?>