@extends('layouts.app')
@section('content')
    <div class="container-fluid px-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h1 class="fw-bold text-uppercase text-secondary">Danh sách sản phẩm</h1>
            <a href="{{ route('products.create') }}" class="btn btn-primary">Thêm sản phẩm</a>
        </div>
        {{-- Hiển thị message --}}
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        <div class="table-responsive shadow-sm">
            <table class="table table-striped table-bordered align-middle table-hover text-center">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Tên</th>
                    <th>Mã SKU</th>
                    <th>Giá đại lý</th>
                    <th>Giá bán lẻ</th>
                    <th>Số lượng</th>
                    <th>Danh mục</th>
                    <th>Hình ảnh</th>
                    <th width="140">Hành động</th>
                </tr>
                </thead>
                <tbody>
                @foreach($products as $p)
                    <tr>
                        <td>{{ $p->id }}</td>
                        <td>{{ $p->name }}</td>
                        <td>{{ $p->sku }}</td>
                        <td>{{ number_format($p->price_agent) }}</td>
                        <td>{{ number_format($p->price_retail) }}</td>
                        <td>{{ number_format($p->stocks->sum('qty')) }}</td>
                        <td>{{ $p->category?->name }}</td>
                        <td>
                            @php
                                $mainMedia = optional($p->mainImage)->media;
                                $imageUrl = $mainMedia?->metadata->url ?? ($mainMedia?->file_path ? Storage::disk('public')->url($mainMedia->file_path) : null);
                            @endphp
                            @if($imageUrl)
                                <img src="{{ $imageUrl }}"
                                     alt="{{ $p->name }}"
                                     width="50"
                                     class="rounded">
                            @else
                                <span class="text-muted">Không có</span>
                            @endif
                        </td>
                        <td>
                            <a href="{{ route('products.edit', $p->id) }}"
                               class="btn btn-sm btn-outline-warning">
                                Sửa
                            </a>
                            <form action="{{ route('products.destroy', $p->id) }}"
                                  method="POST"
                                  class="d-inline-block">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-outline-danger"
                                        onclick="return confirm('Bạn chắc chắn muốn xóa?')">
                                    Xóa
                                </button>
                            </form>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
        {{ $products->links() }}
    </div>
@endsection
