@extends('layouts.app')
@section('content')
    <div class="container-fluid">
        <h2 class="mb-4">Cập nhật sản phẩm</h2>
        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        <form action="{{ route('products.update', $product->id) }}" method="POST" enctype="multipart/form-data">
            @method('PUT')
            @include('products._form', [
                'product' => $product,
                'buttonText' => 'Cập nhật sản phẩm'
            ])
        </form>
    </div>
@endsection
