@php use Carbon\Carbon; @endphp
@extends('layouts.app')

@section('title', 'Chi tiết đơn hàng #' . $order->order_code)

@section('content')
    <div class="container-fluid px-4">
        {{-- Header --}}
        <div class="d-flex justify-content-between align-items-center mb-3 mt-3">
            <div>
                <h1 class="fw-bold text-uppercase text-secondary mb-1">ĐƠN HÀNG #{{ $order->order_code }}</h1>
                <p class="text-muted small mb-0">
                    <i class="bi bi-calendar3"></i> Tạo ngày {{ optional($order->created_at)->format('d/m/Y H:i') }}
                    <span class="mx-1">|</span>
                    <i class="bi bi-person-circle"></i> Bởi {{ optional($order->creator)->name ?? 'Unknown' }}
                </p>
            </div>
            <div class="d-flex gap-2">
                <a href="{{ route('orders.index') }}" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Quay lại
                </a>

                {{-- Chỉ hiện nút sửa khi còn ở Sales --}}
                @can('update', $order)
                    <a href="{{ route('orders.edit', $order->id) }}" class="btn btn-warning">
                        <i class="bi bi-pencil"></i> Sửa
                    </a>
                @endcan
            </div>
        </div>

        {{-- Thông báo --}}
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show">
                <i class="bi bi-check-circle-fill"></i> {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show">
                <i class="bi bi-exclamation-triangle-fill"></i> {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        {{-- Trạng thái hiện tại (Dashboard Mini) --}}
        <div class="row mb-4">
            <div class="col-12">
                <div class="card shadow-sm border-start border-4"
                     style="border-left-color: {{ $order->currentStatusType->color ?? '#6c757d' }} !important;">
                    <div class="card-body py-3">
                        <div class="row align-items-center">
                            {{-- Status --}}
                            <div class="col-md-3 border-end">
                                <h6 class="text-muted small mb-1">TRẠNG THÁI HIỆN TẠI</h6>
                                <span class="badge rounded-pill px-3 py-2 fs-6"
                                      style="background-color: {{ $order->currentStatusType->color ?? '#6c757d' }}">
                                    {{ $order->currentStatusType->name ?? 'Không xác định' }}
                                </span>
                            </div>

                            {{-- Department --}}
                            <div class="col-md-3 border-end">
                                <h6 class="text-muted small mb-1">BỘ PHẬN ĐANG GIỮ</h6>
                                {{-- Sử dụng hàm getDepartmentName() từ Model thay vì array cứng --}}
                                <p class="mb-0 fw-bold fs-5 text-primary">
                                    {{ method_exists($order, 'getDepartmentName') ? $order->getDepartmentName() : ucfirst($order->current_department) }}
                                </p>
                            </div>

                            {{-- Delivery Date --}}
                            <div class="col-md-3 border-end">
                                <h6 class="text-muted small mb-1">DỰ KIẾN GIAO HÀNG</h6>
                                <p class="mb-0 fw-bold">
                                    @if($order->estimated_delivery)
                                        {{ Carbon::parse($order->estimated_delivery)->format('d/m/Y') }}
                                        <small class="text-muted fw-normal">({{ Carbon::parse($order->estimated_delivery)->diffForHumans() }})</small>
                                    @else
                                        <span class="text-muted fst-italic">-- Chưa xác định --</span>
                                    @endif
                                </p>
                            </div>

                            {{-- Action Buttons --}}
                            <div class="col-md-3 text-end">
                                @can('submit', $order)
                                    <form action="{{ route('orders.submit', $order->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-primary w-100"
                                                onclick="return confirm('Bạn có chắc chắn muốn gửi đơn hàng này đi duyệt?')">
                                            <i class="bi bi-send"></i> Gửi duyệt ngay
                                        </button>
                                    </form>
                                @endcan

                                @can('approve', $order)
                                    <a href="{{ route('orders.approval-form', $order->id) }}" class="btn btn-success w-100 pulse-animation">
                                        <i class="bi bi-clipboard-check"></i> Xử lý duyệt
                                    </a>
                                @endcan
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            {{-- Cột trái: Nội dung chính --}}
            <div class="col-lg-8">

                {{-- 1. Thông tin khách hàng --}}
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light fw-bold text-uppercase text-secondary">
                        <i class="bi bi-person-vcard"></i> Thông tin khách hàng
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="mb-2">
                                    <label class="text-muted small">Tên khách hàng:</label>
                                    <div class="fw-bold">{{ $order->lead->customer->name }}</div>
                                </div>
                                <div class="mb-2">
                                    <label class="text-muted small">Số điện thoại:</label>
                                    <div>
                                        <a href="tel:{{ $order->lead->customer->phone }}" class="text-decoration-none">
                                            {{ $order->lead->customer->phone }}
                                        </a>
                                    </div>
                                </div>
                                <div>
                                    <label class="text-muted small">Phân loại:</label>
                                    <div>
                                        <span class="badge bg-info text-dark">
                                            {{ $order->lead->customer->customerType->name ?? 'N/A' }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-2">
                                    <label class="text-muted small">Email:</label>
                                    <div>{{ $order->lead->customer->email ?? '---' }}</div>
                                </div>
                                <div class="mb-2">
                                    <label class="text-muted small">Khu vực:</label>
                                    <div>{{ $order->lead->customer->region->name ?? '---' }}</div>
                                </div>
                                <div>
                                    <label class="text-muted small">Địa chỉ:</label>
                                    <div>{{ $order->lead->customer->address ?? '---' }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- 2. Chi tiết sản phẩm --}}
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light fw-bold text-uppercase text-secondary d-flex justify-content-between">
                        <span><i class="bi bi-box-seam"></i> Chi tiết sản phẩm</span>
                        <span class="badge bg-secondary">{{ $order->items->count() }} mặt hàng</span>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                <tr class="text-secondary small text-uppercase">
                                    <th class="ps-3" style="width: 5%">#</th>
                                    <th style="width: 45%">Sản phẩm</th>
                                    <th style="width: 15%" class="text-end">Đơn giá</th>
                                    <th style="width: 15%" class="text-center">Số lượng</th>
                                    <th style="width: 20%" class="text-end pe-3">Thành tiền</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($order->items as $item)
                                    <tr>
                                        <td class="text-center ps-3">{{ $loop->iteration }}</td>
                                        <td>
                                            <div class="fw-bold text-primary">{{ $item->product->name }}</div>
                                            <div class="small text-muted">Mã SKU: {{ $item->product->sku ?? 'N/A' }}</div>
                                        </td>
                                        <td class="text-end font-monospace">{{ number_format($item->unit_price, 0, ',', '.') }}</td>
                                        <td class="text-center fw-bold">{{ $item->quantity }}</td>
                                        <td class="text-end pe-3 font-monospace fw-bold">{{ number_format($item->line_total, 0, ',', '.') }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                                <tfoot class="table-light border-top">
                                <tr>
                                    <td colspan="4" class="text-end fw-bold text-uppercase py-3">Tổng giá trị đơn hàng:</td>
                                    <td class="text-end pe-3 py-3">
                                        <span class="fs-5 fw-bold text-danger">{{ number_format($order->total_amount, 0, ',', '.') }} đ</span>
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

                {{-- 3. Lịch sử thanh toán --}}
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light fw-bold text-uppercase text-secondary d-flex justify-content-between align-items-center">
                        <span><i class="bi bi-wallet2"></i> Lịch sử thanh toán</span>
                        @php
                            $paid = $order->payments->sum('amount');
                            $remain = $order->total_amount - $paid;
                            $percent = $order->total_amount > 0 ? ($paid / $order->total_amount) * 100 : 0;
                        @endphp
                        <div class="progress" style="width: 150px; height: 10px;">
                            <div class="progress-bar bg-success" role="progressbar" style="width: {{ $percent }}%"></div>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($order->payments->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-sm table-striped">
                                    <thead>
                                    <tr>
                                        <th>Ngày TT</th>
                                        <th>Số tiền</th>
                                        <th>Phương thức</th>
                                        <th>Người ghi nhận</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($order->payments as $payment)
                                        <tr>
                                            <td>{{ Carbon::parse($payment->payment_date)->format('d/m/Y') }}</td>
                                            <td class="fw-bold text-success">+{{ number_format($payment->amount, 0, ',', '.') }}</td>
                                            <td><span class="badge bg-light text-dark border">{{ $payment->method->method_name ?? 'N/A' }}</span></td>
                                            <td><small>{{ $payment->recordedBy->name ?? 'System' }}</small></td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="text-center text-muted my-2">Chưa có giao dịch thanh toán nào.</p>
                        @endif

                        <div class="d-flex justify-content-between border-top pt-2 mt-2">
                            <span class="text-muted">Đã thanh toán: <strong>{{ number_format($paid, 0, ',', '.') }} đ</strong></span>
                            <span class="text-danger">Còn lại: <strong>{{ number_format($remain, 0, ',', '.') }} đ</strong></span>
                        </div>
                    </div>
                </div>

                {{-- 4. Timeline (Lịch sử xử lý) --}}
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light fw-bold text-uppercase text-secondary">
                        <i class="bi bi-clock-history"></i> Nhật ký xử lý
                    </div>
                    <div class="card-body">
                        <div class="timeline">
                            @forelse($timeline as $item)
                                <div class="timeline-item pb-3 ps-4 position-relative border-start border-2 ms-2">
                                    <div class="position-absolute start-0 translate-middle-x bg-white" style="top: 0;">
                                        <i class="bi bi-check-circle-fill text-{{ $item->to_department == 'completed' ? 'success' : 'primary' }}"></i>
                                    </div>
                                    <div class="ms-2">
                                        <div class="d-flex justify-content-between">
                                            <strong>{{ $item->statusType->name ?? 'Thay đổi trạng thái' }}</strong>
                                            <small class="text-muted">{{ $item->changed_at ? Carbon::parse($item->changed_at)->format('d/m/Y H:i') : '' }}</small>
                                        </div>
                                        <p class="mb-1 small text-muted">
                                            @if($item->from_department)
                                                {{ ucfirst($item->from_department) }} <i class="bi bi-arrow-right"></i>
                                            @endif
                                            <span class="badge bg-secondary">{{ ucfirst($item->to_department) }}</span>
                                        </p>
                                        <div class="p-2 bg-light rounded small fst-italic">
                                            "{{ $item->note ?? 'Không có ghi chú' }}"
                                        </div>
                                        <div class="small mt-1 text-muted">
                                            <i class="bi bi-person"></i> Thực hiện: {{ $item->changedBy->name ?? 'Hệ thống' }}
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="text-center text-muted">Chưa có lịch sử ghi nhận.</div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>

            {{-- Cột phải: Sidebar --}}
            <div class="col-lg-4">
                {{-- Thông tin nội bộ --}}
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-dark text-white text-uppercase fw-bold small">
                        <i class="bi bi-info-square"></i> Thông tin nội bộ
                    </div>
                    <div class="card-body">
                        <table class="table table-sm table-borderless mb-0">
                            <tr>
                                <td class="text-muted">Mã đơn:</td>
                                <td class="fw-bold text-end font-monospace">{{ $order->order_code }}</td>
                            </tr>
                            <tr>
                                <td class="text-muted">Ngày đặt:</td>
                                <td class="text-end">{{ $order->order_date ? Carbon::parse($order->order_date)->format('d/m/Y') : '-' }}</td>
                            </tr>
                            <tr>
                                <td class="text-muted">Kho xuất:</td>
                                <td class="text-end"><a href="#" class="text-decoration-none">{{ $order->warehouse->name ?? 'N/A' }}</a></td>
                            </tr>
                            <tr>
                                <td class="text-muted">Người tạo:</td>
                                <td class="text-end">{{ $order->creator->name ?? 'N/A' }}</td>
                            </tr>
                            @if($order->approved_by)
                                <tr class="border-top">
                                    <td class="text-muted pt-2">Duyệt cuối:</td>
                                    <td class="text-end pt-2 fw-bold text-success">{{ $order->approver->name ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Ngày duyệt:</td>
                                    <td class="text-end">{{ $order->approved_at ? Carbon::parse($order->approved_at)->format('d/m/Y H:i') : '-' }}</td>
                                </tr>
                            @endif
                        </table>
                    </div>
                </div>

                {{-- Thông báo riêng (Chỉ Sales thấy) --}}
                @if(isset($notifications) && $notifications->count() > 0 && Auth::id() == $order->created_by)
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-warning text-dark fw-bold">
                            <i class="bi bi-bell"></i> Thông báo mới
                        </div>
                        <div class="list-group list-group-flush">
                            @foreach($notifications as $notif)
                                <div class="list-group-item list-group-item-action {{ $notif->is_read ? 'bg-light' : '' }}">
                                    <div class="d-flex w-100 justify-content-between">
                                        <strong class="mb-1 text-truncate" style="max-width: 200px;">{{ $notif->title }}</strong>
                                        <small class="text-muted">{{ $notif->created_at->diffForHumans() }}</small>
                                    </div>
                                    <p class="mb-1 small">{{ $notif->message }}</p>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

                {{-- Control Panel (Các nút thao tác) --}}
                <div class="card shadow-sm sticky-top" style="top: 20px;">
                    <div class="card-header bg-secondary text-white fw-bold">
                        <i class="bi bi-gear"></i> Bảng điều khiển
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            {{-- Nút thanh toán --}}
                            @can('recordPayment', $order)
                                <button class="btn btn-outline-success text-start" data-bs-toggle="modal" data-bs-target="#paymentModal">
                                    <i class="bi bi-cash-coin me-2"></i> Ghi nhận thanh toán
                                </button>
                            @endcan

                            {{-- Nút xuất kho --}}
                            @can('ship', $order)
                                <button class="btn btn-outline-primary text-start" data-bs-toggle="modal" data-bs-target="#shipModal">
                                    <i class="bi bi-box-seam-fill me-2"></i> Xác nhận xuất kho
                                </button>
                            @endcan

                            {{-- Nút hủy đơn --}}
                            @can('delete', $order)
                                <hr class="my-2">
                                <form action="{{ route('orders.destroy', $order->id) }}" method="POST">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger w-100"
                                            onclick="return confirm('CẢNH BÁO: Hành động này không thể hoàn tác.\nBạn có chắc chắn muốn hủy đơn hàng này?')">
                                        <i class="bi bi-trash3 me-2"></i> Hủy đơn hàng
                                    </button>
                                </form>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- MODAL 1: Thanh toán --}}
    <div class="modal fade" id="paymentModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="{{ route('orders.record-payment', $order->id) }}" method="POST">
                    @csrf
                    <div class="modal-header bg-success text-white">
                        <h5 class="modal-title"><i class="bi bi-cash"></i> Ghi nhận thanh toán</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-light border">
                            Tổng tiền đơn hàng: <strong>{{ number_format($order->total_amount) }} đ</strong><br>
                            Đã thanh toán: <strong class="text-success">{{ number_format($order->payments->sum('amount')) }} đ</strong><br>
                            Còn nợ: <strong class="text-danger">{{ number_format($order->total_amount - $order->payments->sum('amount')) }} đ</strong>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Ngày thanh toán</label>
                            <input type="date" name="payment_date" class="form-control" value="{{ date('Y-m-d') }}" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Số tiền thực nhận</label>
                            <div class="input-group">
                                <input type="number" name="amount" class="form-control" step="1000"
                                       value="{{ $order->total_amount - $order->payments->sum('amount') }}" required>
                                <span class="input-group-text">VNĐ</span>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Phương thức thanh toán <span class="text-danger">*</span></label>
                            <select name="method_id" class="form-select" required>
                                <option value="">-- Chọn phương thức --</option>
                                {{-- Loop qua biến paymentMethods được truyền từ Controller --}}
                                @if(isset($paymentMethods))
                                    @foreach($paymentMethods as $method)
                                        <option value="{{ $method->id }}">{{ $method->method_name }} ({{ $method->code }})</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Ghi chú giao dịch</label>
                            <textarea name="note" class="form-control" rows="2" placeholder="Mã giao dịch ngân hàng, người nộp tiền..."></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
                        <button type="submit" class="btn btn-success">Lưu thanh toán</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- MODAL 2: Xuất kho (Đã bổ sung) --}}
    <div class="modal fade" id="shipModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="{{ route('orders.ship', $order->id) }}" method="POST">
                    @csrf
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title"><i class="bi bi-box-seam"></i> Xác nhận xuất kho</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle"></i> Hành động này sẽ trừ tồn kho của <strong>{{ $order->items->count() }}</strong> loại sản phẩm và hoàn tất đơn hàng.
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Ghi chú xuất kho (nếu có)</label>
                            <textarea name="shipping_note" class="form-control" rows="3" placeholder="Thông tin đơn vị vận chuyển, mã vận đơn..."></textarea>
                        </div>

                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" required id="confirmShip">
                            <label class="form-check-label" for="confirmShip">
                                Tôi xác nhận hàng hóa đã sẵn sàng để giao.
                            </label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                        <button type="submit" class="btn btn-primary">Xác nhận xuất</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- CSS Inline nhỏ cho animation --}}
    <style>
        .pulse-animation {
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(25, 135, 84, 0.7); }
            70% { box-shadow: 0 0 0 10px rgba(25, 135, 84, 0); }
            100% { box-shadow: 0 0 0 0 rgba(25, 135, 84, 0); }
        }
    </style>
@endsection