<div class="card shadow-sm mb-3">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0"><i class="bi bi-bag"></i> Thông tin đơn hàng</h5>
    </div>
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Chọn khách hàng <span class="text-danger">*</span></label>
                <select name="customer_id" id="customerSelect" class="form-select" required>
                    <option value="">-- Chọn khách hàng --</option>
                    @foreach($customers as $customer)
                        <option value="{{ $customer['id'] }}"
                                data-lead-id="{{ $customer['lead_id'] }}"
                                {{ old('customer_id') == $customer['id'] ? 'selected' : '' }}>
                            {{ $customer['display'] }}
                        </option>
                    @endforeach
                </select>
                <input type="hidden" name="lead_id" id="leadIdInput" value="{{ old('lead_id') }}">
            </div>

            <div class="col-md-6">
                <label class="form-label">Ngày đặt hàng <span class="text-danger">*</span></label>
                <input type="date"
                       name="order_date"
                       class="form-control"
                       value="{{ old('order_date', date('Y-m-d')) }}"
                       required>
            </div>

            <div class="col-md-6">
                <label class="form-label">Kho xuất <span class="text-danger">*</span></label>
                <select name="warehouse_id" id="warehouseSelect" class="form-select" required>
                    <option value="">-- Chọn kho --</option>
                    @foreach($warehouses as $wh)
                        <option value="{{ $wh['id'] }}" {{ old('warehouse_id') == $wh['id'] ? 'selected' : '' }}>
                            {{ $wh['name'] }} - {{ $wh['location'] }}
                        </option>
                    @endforeach
                </select>
            </div>
        </div>

        <div id="customerInfo" class="mt-3 p-3 bg-light rounded" style="display: none;">
            <h6 class="text-primary mb-2"><i class="bi bi-person"></i> Thông tin khách hàng</h6>
            <div class="row small">
                <div class="col-md-6">
                    <p class="mb-1"><strong>Loại khách:</strong> <span id="customerType"></span></p>
                    <p class="mb-1"><strong>Khu vực:</strong> <span id="customerRegion"></span></p>
                </div>
                <div class="col-md-6">
                    <p class="mb-1"><strong>Tổng đơn đã mua:</strong> <span id="customerOrders"></span></p>
                    <p class="mb-1"><strong>Công nợ:</strong> <span id="customerDebt" class="text-danger"></span></p>
                </div>
            </div>
        </div>
    </div>
</div>