@extends('layouts.app')
@section('title', 'Danh sách đơn hàng')
@section('content')
    <div class="container-fluid px-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h1 class="fw-bold text-uppercase text-secondary">DANH SÁCH ĐƠN HÀNG</h1>
            @can('create', App\Models\CRM\Order::class)
                <a href="{{ route('orders.create') }}" class="btn btn-primary">
                    <i class="bi bi-plus-lg"></i> Tạo đơn mới
                </a>
            @endcan
        </div>

        {{-- Thông báo --}}
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show">
                <i class="bi bi-check-circle"></i> {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        {{-- Bộ lọc --}}
        <form action="{{ route('orders.index') }}" method="GET" class="mb-3">
            <div class="card shadow-sm">
                <div class="card-body">
                    <div class="row g-2 align-items-end">
                        <div class="col-md-3">
                            <label class="form-label small">Tìm kiếm</label>
                            <input type="text" name="search" class="form-control form-control-sm"
                                   value="{{ request('search') }}"
                                   placeholder="Mã đơn, tên khách...">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label small">Trạng thái</label>
                            <select name="status" class="form-select form-select-sm">
                                <option value="">-- Tất cả --</option>
                                <option value="sales" {{ request('status') == 'sales' ? 'selected' : '' }}>Chờ gửi duyệt</option>
                                <option value="ketoan" {{ request('status') == 'ketoan' ? 'selected' : '' }}>Chờ kế toán</option>
                                <option value="duyet1" {{ request('status') == 'duyet1' ? 'selected' : '' }}>Chờ duyệt cấp 1</option>
                                <option value="duyet2" {{ request('status') == 'duyet2' ? 'selected' : '' }}>Chờ giám đốc</option>
                                <option value="kho" {{ request('status') == 'kho' ? 'selected' : '' }}>Chờ xuất kho</option>
                                <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Hoàn tất</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label small">Từ ngày</label>
                            <input type="date" name="from_date" class="form-control form-control-sm"
                                   value="{{ request('from_date') }}">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label small">Đến ngày</label>
                            <input type="date" name="to_date" class="form-control form-control-sm"
                                   value="{{ request('to_date') }}">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label small">Kho</label>
                            <select name="warehouse_id" class="form-select form-select-sm">
                                <option value="">-- Tất cả --</option>
                                @foreach($warehouses ?? [] as $wh)
                                    <option value="{{ $wh->id }}" {{ request('warehouse_id') == $wh->id ? 'selected' : '' }}>
                                        {{ $wh->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button type="submit" class="btn btn-primary btn-sm w-100">
                                <i class="bi bi-search"></i> Lọc
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>

        {{-- Bảng danh sách --}}
        <div class="table-responsive shadow-sm">
            <table class="table table-striped table-bordered align-middle table-hover">
                <thead class="table-dark small text-center">
                <tr>
                    <th style="width: 5%">#</th>
                    <th style="width: 12%">Mã đơn</th>
                    <th style="width: 10%">Ngày đặt</th>
                    <th style="width: 18%">Khách hàng</th>
                    <th style="width: 10%">Tổng tiền</th>
                    <th style="width: 12%">Trạng thái</th>
                    <th style="width: 12%">Bộ phận hiện tại</th>
                    <th style="width: 11%">Người tạo</th>
                    <th style="width: 10%">Thao tác</th>
                </tr>
                </thead>
                <tbody class="small">
                @forelse($orders as $order)
                    <tr>
                        <td class="text-center">{{ $loop->iteration }}</td>
                        <td>
                            <a href="{{ route('orders.show', $order->id) }}" class="text-decoration-none fw-bold">
                                {{ $order->order_code }}
                            </a>
                        </td>
                        <td class="text-center">{{ $order->order_date ? \Carbon\Carbon::parse($order->order_date)->format('d/m/Y') : '-' }}</td>
                        <td>
                            <div class="fw-semibold">{{ $order->lead->customer->name }}</div>
                            <small class="text-muted">{{ $order->lead->customer->phone }}</small>
                        </td>
                        <td class="text-end">
                            <span class="fw-bold text-primary">{{ number_format($order->total_amount, 0, ',', '.') }} đ</span>
                        </td>
                        <td class="text-center">
                        <span class="badge" style="background-color: {{ $order->currentStatusType->color ?? '#6c757d' }}">
                            {{ $order->currentStatusType->name ?? 'N/A' }}
                        </span>
                        </td>
                        <td class="text-center">
                            @php
                                $deptBadges = [
                                    'sales' => 'secondary',
                                    'ketoan' => 'info',
                                    'duyet1' => 'warning',
                                    'duyet2' => 'primary',
                                    'kho' => 'dark',
                                    'completed' => 'success'
                                ];
                                $badgeClass = $deptBadges[$order->current_department] ?? 'secondary';
                            @endphp
                            <span class="badge bg-{{ $badgeClass }}">
                            {{ ucfirst($order->current_department) }}
                        </span>
                        </td>
                        <td>{{ $order->creator->name ?? 'N/A' }}</td>
                        <td class="text-center">
                            <div class="btn-group btn-group-sm">
                                <a href="{{ route('orders.show', $order->id) }}"
                                   class="btn btn-outline-info" title="Xem chi tiết">
                                    <i class="bi bi-eye"></i>
                                </a>

                                @can('update', $order)
                                    <a href="{{ route('orders.edit', $order->id) }}"
                                       class="btn btn-outline-warning" title="Sửa">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                @endcan

                                @can('approve', $order)
                                    <a href="{{ route('orders.approval-form', $order->id) }}"
                                       class="btn btn-outline-success" title="Duyệt">
                                        <i class="bi bi-check-circle"></i>
                                    </a>
                                @endcan
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="9" class="text-center text-muted py-4">
                            Không có đơn hàng nào.
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>

        {{-- Phân trang --}}
        <div class="mt-3">
            {{ $orders->links('pagination::bootstrap-5') }}
        </div>
    </div>
@endsection