@extends('layouts.app')
@section('title', 'Chỉnh sửa đơn hàng #' . $order->order_code)

@section('content')
    <div class="container-fluid px-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <h1 class="fw-bold text-uppercase text-secondary">CHỈNH SỬA ĐƠN HÀNG</h1>
                <p class="text-muted mb-0">Mã đơn: <strong>{{ $order->order_code }}</strong></p>
            </div>
            <div>
                <a href="{{ route('orders.show', $order->id) }}" class="btn btn-outline-secondary">
                    <i class="bi bi-eye"></i> Xem đơn
                </a>
                <a href="{{ route('orders.index') }}" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Quay lại
                </a>
            </div>
        </div>

        {{-- Warning if order is not editable --}}
        @if($order->current_department !== 'sales')
            <div class="alert alert-warning">
                <i class="bi bi-exclamation-triangle"></i>
                <strong>Cảnh báo:</strong> Đơn hàng đã được gửi duyệt và không thể chỉnh sửa.
            </div>
        @endif

        {{-- Success Message --}}
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        {{-- Error Message --}}
        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        {{-- Validation Errors --}}
        @if($errors->any())
            <div class="alert alert-danger alert-dismissible fade show">
                <strong>Có lỗi xảy ra:</strong>
                <ul class="mb-0 mt-2">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <form action="{{ route('orders.update', $order->id) }}"
              method="POST"
              id="orderForm">
            @csrf
            @method('PUT')

            <div class="row">
                <div class="col-md-8">
                    {{-- Order Info --}}
                    <div class="card shadow-sm mb-3">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0"><i class="bi bi-bag"></i> Thông tin đơn hàng</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Khách hàng <span class="text-danger">*</span></label>
                                    <select name="customer_id" id="customerSelect" class="form-select" required>
                                        <option value="">-- Chọn khách hàng --</option>
                                        @foreach($customers as $customer)
                                            <option value="{{ $customer['id'] }}"
                                                    data-lead-id="{{ $customer['lead_id'] }}"
                                                    {{ old('customer_id', $order->lead->customer_id) == $customer['id'] ? 'selected' : '' }}>
                                                {{ $customer['display'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <input type="hidden" name="lead_id" id="leadIdInput"
                                           value="{{ old('lead_id', $order->lead_id) }}">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Ngày đặt hàng <span class="text-danger">*</span></label>
                                    <input type="date"
                                           name="order_date"
                                           class="form-control"
                                           value="{{ old('order_date', $order->order_date->format('Y-m-d')) }}"
                                           required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Kho xuất <span class="text-danger">*</span></label>
                                    <select name="warehouse_id" id="warehouseSelect" class="form-select" required>
                                        <option value="">-- Chọn kho --</option>
                                        @foreach($warehouses as $wh)
                                            <option value="{{ $wh['id'] }}"
                                                    {{ old('warehouse_id', $order->warehouse_id) == $wh['id'] ? 'selected' : '' }}>
                                                {{ $wh['name'] }} - {{ $wh['location'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Trạng thái hiện tại</label>
                                    <input type="text"
                                           class="form-control"
                                           value="{{ $order->currentStatusType->name ?? 'N/A' }}"
                                           readonly>
                                </div>
                            </div>

                            {{-- Customer Info --}}
                            <div id="customerInfo" class="mt-3 p-3 bg-light rounded">
                                <h6 class="text-primary mb-2"><i class="bi bi-person"></i> Thông tin khách hàng</h6>
                                <div class="row small">
                                    <div class="col-md-6">
                                        <p class="mb-1"><strong>Loại khách:</strong>
                                            <span id="customerType">{{ $order->lead->customer->customerType->name ?? 'N/A' }}</span>
                                        </p>
                                        <p class="mb-1"><strong>Khu vực:</strong>
                                            <span id="customerRegion">{{ $order->lead->customer->region->name ?? 'N/A' }}</span>
                                        </p>
                                    </div>
                                    <div class="col-md-6">
                                        <p class="mb-1"><strong>Tổng đơn đã mua:</strong>
                                            <span id="customerOrders">{{ $order->lead->customer->orders->count() }}</span>
                                        </p>
                                        <p class="mb-1"><strong>Công nợ:</strong>
                                            <span id="customerDebt" class="text-danger">
                                            {{ number_format($order->lead->customer->unpaidDebts->sum('debt_amount')) }} đ
                                        </span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Products Table --}}
                    <div class="card shadow-sm">
                        <div class="card-header bg-success text-white d-flex justify-content-between">
                            <h5 class="mb-0"><i class="bi bi-cart"></i> Sản phẩm</h5>
                            <button type="button" class="btn btn-sm btn-light" id="addProductBtn">
                                <i class="bi bi-plus"></i> Thêm sản phẩm
                            </button>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="productTable">
                                    <thead class="table-light">
                                    <tr>
                                        <th style="width: 40%">Sản phẩm</th>
                                        <th style="width: 15%">Đơn giá</th>
                                        <th style="width: 15%">Số lượng</th>
                                        <th style="width: 20%">Thành tiền</th>
                                        <th style="width: 10%"></th>
                                    </tr>
                                    </thead>
                                    <tbody id="productTableBody">
                                    @foreach($order->items as $index => $item)
                                        <tr class="product-row" data-index="{{ $index }}">
                                            <td>
                                                <select name="items[{{ $index }}][product_id]"
                                                        class="form-select form-select-sm product-select"
                                                        required
                                                        data-index="{{ $index }}">
                                                    <option value="">-- Chọn sản phẩm --</option>
                                                    <option value="{{ $item->product_id }}"
                                                            data-price="{{ $item->product->price }}"
                                                            data-price-agent="{{ $item->product->price_agent }}"
                                                            data-price-retail="{{ $item->product->price_retail }}"
                                                            selected>
                                                        {{ $item->product->name }} ({{ $item->product->sku }})
                                                    </option>
                                                </select>
                                            </td>
                                            <td>
                                                <input type="number"
                                                       name="items[{{ $index }}][unit_price]"
                                                       class="form-control form-control-sm text-end unit-price"
                                                       step="0.01"
                                                       value="{{ $item->unit_price }}"
                                                       required
                                                       readonly>
                                            </td>
                                            <td>
                                                <input type="number"
                                                       name="items[{{ $index }}][quantity]"
                                                       class="form-control form-control-sm text-center quantity"
                                                       min="1"
                                                       value="{{ $item->quantity }}"
                                                       required>
                                            </td>
                                            <td>
                                                <input type="text"
                                                       class="form-control form-control-sm text-end line-total"
                                                       value="{{ number_format($item->quantity * $item->unit_price) }} đ"
                                                       readonly>
                                            </td>
                                            <td class="text-center">
                                                <button type="button"
                                                        class="btn btn-sm btn-danger remove-product-btn">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                    <tfoot>
                                    <tr class="table-secondary fw-bold">
                                        <td colspan="3" class="text-end">TỔNG CỘNG:</td>
                                        <td class="text-end" id="grandTotal">
                                            {{ number_format($order->total_amount) }} đ
                                        </td>
                                        <td></td>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Sidebar --}}
                <div class="col-md-4">
                    <div class="card shadow-sm sticky-top" style="top: 20px;">
                        <div class="card-header bg-warning">
                            <h5 class="mb-0"><i class="bi bi-info-circle"></i> Tóm tắt</h5>
                        </div>
                        <div class="card-body">
                            <table class="table table-sm">
                                <tr>
                                    <td>Mã đơn:</td>
                                    <td class="text-end fw-bold">{{ $order->order_code }}</td>
                                </tr>
                                <tr>
                                    <td>Tổng sản phẩm:</td>
                                    <td class="text-end fw-bold" id="totalItems">{{ $order->items->count() }}</td>
                                </tr>
                                <tr>
                                    <td>Tổng số lượng:</td>
                                    <td class="text-end fw-bold" id="totalQuantity">{{ $order->items->sum('quantity') }}</td>
                                </tr>
                                <tr class="table-primary">
                                    <td>Tổng tiền:</td>
                                    <td class="text-end fw-bold fs-5" id="totalAmount">
                                        {{ number_format($order->total_amount) }} đ
                                    </td>
                                </tr>
                            </table>

                            <hr>

                            <div class="mb-3">
                                <small class="text-muted">
                                    <i class="bi bi-clock-history"></i> Tạo: {{ $order->created_at->format('d/m/Y H:i') }}<br>
                                    <i class="bi bi-person"></i> Bởi: {{ $order->creator->name }}
                                </small>
                            </div>

                            <div class="d-grid gap-2">
                                @if($order->current_department === 'sales')
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save"></i> Cập nhật đơn hàng
                                    </button>
                                    <a href="{{ route('orders.show', $order->id) }}"
                                       class="btn btn-outline-secondary">
                                        <i class="bi bi-x"></i> Hủy
                                    </a>
                                @else
                                    <div class="alert alert-warning mb-0 small">
                                        Đơn hàng đã được gửi duyệt và không thể chỉnh sửa.
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    {{-- Order Timeline --}}
                    @if($order->statusHistory && $order->statusHistory->count() > 0)
                        <div class="card shadow-sm mt-3">
                            <div class="card-header bg-info text-white">
                                <h6 class="mb-0"><i class="bi bi-clock-history"></i> Lịch sử đơn hàng</h6>
                            </div>
                            <div class="card-body">
                                <div class="timeline">
                                    @foreach($order->statusHistory->take(5) as $history)
                                        <div class="timeline-item small mb-2">
                                            <div class="text-muted">{{ $history->changed_at->format('d/m/Y H:i') }}</div>
                                            <div>{{ $history->note }}</div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </form>
    </div>
@endsection
@section('scripts')
    <script>
        // Set initial state
        let rowIndex = {{ $order->items->count() }};
        let customerTypeId = {{ $order->lead->customer->customer_type_id ?? 'null' }};
        let selectedWarehouseId = {{ $order->warehouse_id }};

        // Reuse the same OrderFormManager from create page
    </script>
    <script src="{{ asset('js/order-form.js') }}?v={{ filemtime(public_path('js/order-form.js')) }}"></script>
@endsection

@section('styles')
    <style>
        .timeline-item {
            padding-left: 20px;
            border-left: 2px solid #dee2e6;
            position: relative;
        }

        .timeline-item:before {
            content: '';
            position: absolute;
            left: -5px;
            top: 5px;
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: #0d6efd;
        }

        .timeline-item:last-child {
            border-left-color: transparent;
        }
    </style>
@endsection
