@extends('layouts.app')

@section('title', 'Dashboard CRM')

@section('content')

	<style>
		/* DARK MODE */
		body.dark-mode {
			background: #1e1e1e;
			color: #ddd;
		}
		body.dark-mode .card {
			background: #2b2b2b;
			color: #fff !important;
		}
		body.dark-mode table {
			color: #fff !important;
		}
	</style>

	<div class="container-fluid">

		{{-- HEADER + DARK MODE TOGGLE --}}
		<div class="d-flex justify-content-between align-items-center mb-4">
			<h1 class="fw-bold">📊 Tổng quan CRM</h1>

			<button id="darkModeToggle" class="btn btn-dark">
				🌙 Dark Mode
			</button>
		</div>

		{{-- FILTER --}}
		<form action="{{ route('dashboard') }}" method="GET" class="mb-4">
			<div class="row g-2 align-items-end">
				<div class="col-md-3">
					<label>Từ ngày</label>
					<input type="date" name="from" value="{{ request('from') }}" class="form-control">
				</div>
				<div class="col-md-3">
					<label>Đến ngày</label>
					<input type="date" name="to" value="{{ request('to') }}" class="form-control">
				</div>
				<div class="col-md-3">
					<label>Theo kỳ</label>
					<select name="period" class="form-select">
						<option value="">-- Tuỳ chọn --</option>
						<option value="7days"  {{ request('period')=='7days'?'selected':'' }}>7 ngày gần nhất</option>
						<option value="30days" {{ request('period')=='30days'?'selected':'' }}>30 ngày gần nhất</option>
						<option value="month"  {{ request('period')=='month'?'selected':'' }}>Tháng này</option>
						<option value="year"   {{ request('period')=='year'?'selected':'' }}>Năm nay</option>
					</select>
				</div>

				<div class="col-md-3">
					<button class="btn btn-primary w-100">Lọc dữ liệu</button>
				</div>
			</div>
		</form>

		{{-- TOP STATS --}}
		<div class="row g-4 mb-4">
			<div class="col-md-3">
				<div class="card p-3 text-center shadow-sm">
					<h6 class="text-muted">Tổng khách hàng</h6>
					<h2 class="fw-bold">{{ $total_customers }}</h2>
				</div>
			</div>

			<div class="col-md-3">
				<div class="card p-3 text-center shadow-sm">
					<h6 class="text-muted">Khách có mua hàng</h6>
					<h2 class="fw-bold">{{ $total_customers_buy }}</h2>
				</div>
			</div>

			<div class="col-md-3">
				<div class="card p-3 text-center shadow-sm">
					<h6 class="text-muted">Lead</h6>
					<h2 class="fw-bold">{{ $total_leads }}</h2>
				</div>
			</div>

			<div class="col-md-3">
				<div class="card p-3 text-center shadow-sm">
					<h6 class="text-muted">Đơn hàng</h6>
					<h2 class="fw-bold">{{ $total_orders }}</h2>
				</div>
			</div>
		</div>

		{{-- TOTAL PAYMENT --}}
		<div class="row mb-4">
			<div class="col-md-12">
				<div class="card p-3 text-center shadow-sm">
					<h6 class="text-muted">Tổng thanh toán</h6>
					<h2 class="fw-bold text-success">{{ number_format($total_payments) }} đ</h2>
				</div>
			</div>
		</div>

		{{-- CHARTS: LINE + BAR --}}
		<div class="row g-4 mb-4">
			<div class="col-md-6">
				<div class="card p-3 shadow-sm">
					<h5 class="fw-bold">📈 Doanh thu theo tháng</h5>
					<canvas id="revenueChart"></canvas>
				</div>
			</div>

			<div class="col-md-6">
				<div class="card p-3 shadow-sm">
					<h5 class="fw-bold">🔥 TOP nhân viên Sales theo doanh thu</h5>
					<canvas id="topSalesChart"></canvas>
				</div>
			</div>
		</div>

		{{-- DOUGHNUT/PIE --}}
		<div class="row g-4 mb-4">
			<div class="col-md-4">
				<div class="card p-3 shadow-sm">
					<h5 class="fw-bold">🎯 Tỉ lệ khách mua</h5>
					<canvas id="customerPie"></canvas>
				</div>
			</div>

			<div class="col-md-4">
				<div class="card p-3 shadow-sm">
					<h5 class="fw-bold">📣 Tỉ lệ nguồn Lead</h5>
					<canvas id="leadSourcePie"></canvas>
				</div>
			</div>

			<div class="col-md-4">
				<div class="card p-3 shadow-sm">
					<h5 class="fw-bold">📑 Tỉ lệ trạng thái đơn hàng</h5>
					<canvas id="orderStatusPie"></canvas>
				</div>
			</div>
		</div>

		{{-- TOP SALES --}}
		<div class="card p-3 shadow-sm mb-4">
			<h5 class="fw-bold">🔥 Top nhân viên bán hàng</h5>
			<table class="table table-hover">
				<thead>
				<tr>
					<th>Nhân viên</th>
					<th class="text-end">Doanh thu</th>
				</tr>
				</thead>
				<tbody>
				@foreach($top_sales as $s)
					<tr>
						<td>{{ $s->name }}</td>
						<td class="text-end">{{ number_format($s->revenue) }} đ</td>
					</tr>
				@endforeach
				</tbody>
			</table>
		</div>

	</div>
@endsection

@section('scripts')
	<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

	<script>
		/* ---------------- DARK MODE ------------------- */
		document.getElementById('darkModeToggle').addEventListener('click', function () {
			document.body.classList.toggle('dark-mode');
		});

		/* ---------------- LINE: Revenue ------------------- */
		new Chart(document.getElementById('revenueChart'), {
			type: "line",
			data: {
				labels: {!! json_encode($revenue_by_month->pluck('month')) !!},
				datasets: [{
					label: "Doanh thu",
					data: {!! json_encode($revenue_by_month->pluck('revenue')) !!},
					borderWidth: 3,
					borderColor: "#0d6efd"
				}]
			}
		});

		/* ---------------- BAR: Orders ------------------- */
		{{--new Chart(document.getElementById('orderChart'), {--}}
		{{--	type: "bar",--}}
		{{--	data: {--}}
		{{--		labels: {!! json_encode($orders_by_month->pluck('month')) !!},--}}
		{{--		datasets: [{--}}
		{{--			label: "Số đơn",--}}
		{{--			data: {!! json_encode($orders_by_month->pluck('total_orders')) !!},--}}
		{{--			backgroundColor: "#198754"--}}
		{{--		}]--}}
		{{--	}--}}
		{{--});--}}
		new Chart(document.getElementById('topSalesChart'), {
			type: "bar",
			data: {
				labels: {!! json_encode($top_sales->pluck('name')) !!},
				datasets: [{
					label: "Doanh thu",
					data: {!! json_encode($top_sales->pluck('revenue')) !!},
					backgroundColor: "#198754"
				}]
			},
			options: {
				responsive: true,
				plugins: {
					legend: { display: false },
					tooltip: { mode: 'index', intersect: false }
				},
				scales: {
					y: {
						beginAtZero: true,
						ticks: {
							callback: function(value) {
								return value.toLocaleString() + ' đ';
							}
						}
					}
				}
			}
		});
		/* ---------------- PIE: Customer Purchase Ratio ------------------- */
		new Chart(document.getElementById('customerPie'), {
			type: "doughnut",
			data: {
				labels: ["Có mua", "Chưa mua"],
				datasets: [{
					data: [{{ $total_customers_buy }}, {{ $total_customers - $total_customers_buy }}],
				}]
			}
		});

		/* ---------------- PIE: Lead Source ------------------- */
		new Chart(document.getElementById('leadSourcePie'), {
			type: "pie",
			data: {
				labels: {!! json_encode($lead_sources->pluck('source_name')) !!},
				datasets: [{
					data: {!! json_encode($lead_sources->pluck('total')) !!}
				}]
			}
		});

		/* ---------------- PIE: Order Status ------------------- */
		new Chart(document.getElementById('orderStatusPie'), {
			type: "pie",
			data: {
				labels: {!! json_encode($order_status_chart->pluck('status')) !!},
				datasets: [{
					data: {!! json_encode($order_status_chart->pluck('total')) !!}
				}]
			}
		});
	</script>

@endsection
