@extends('layouts.app')
@section('title', 'Chi tiết khách hàng')
@section('content')
    <div class="container-fluid px-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h1 class="fw-bold text-uppercase text-secondary">CHI TIẾT KHÁCH HÀNG</h1>
            <div>
                <a href="{{ route('customers.edit', $customer->id) }}" class="btn btn-warning">
                    <i class="bi bi-pencil"></i> Sửa
                </a>
                <a href="{{ route('customers.index') }}" class="btn btn-secondary">
                    <i class="bi bi-arrow-left"></i> Quay lại
                </a>
            </div>
        </div>

        <div class="row">
            {{-- Thông tin cơ bản --}}
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Thông tin cơ bản</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tr>
                                <th width="40%">Tên khách hàng:</th>
                                <td>{{ $customer->name }}</td>
                            </tr>
                            <tr>
                                <th>Biệt danh:</th>
                                <td>{{ $customer->nickname ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Số điện thoại:</th>
                                <td>{{ $customer->phone ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Email:</th>
                                <td>{{ $customer->email ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Địa chỉ:</th>
                                <td>{{ $customer->address ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Khu vực:</th>
                                <td>{{ $customer->region->name ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Loại khách:</th>
                                <td>{{ $customer->customerType->name ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Trạng thái:</th>
                                <td>
                                    <span class="badge {{ $customer->customer_status == 'member' ? 'bg-success' : 'bg-warning' }}">
                                        {{ $customer->customer_status == 'member' ? 'Hội viên' : 'Lead' }}
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <th>Đánh giá:</th>
                                <td>
                                    @if($customer->is_potential)
                                        <span class="badge bg-info">⭐ Tiềm năng</span>
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

            {{-- Thông tin liên hệ --}}
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">Thông tin liên hệ</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tr>
                                <th width="40%">Facebook:</th>
                                <td>
                                    @if($customer->facebook_link)
                                        <a href="{{ $customer->facebook_link }}" target="_blank">{{ $customer->facebook_name ?? 'Link' }}</a>
                                    @else
                                        {{ $customer->facebook_name ?? '-' }}
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Zalo ID:</th>
                                <td>{{ $customer->zalo_id ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Người phụ trách:</th>
                                <td>{{ $customer->assignedUser->name ?? 'Chưa gán' }}</td>
                            </tr>
                            <tr>
                                <th>Ghi chú nhóm:</th>
                                <td>{{ $customer->group_note ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Ngày tạo:</th>
                                <td>{{ $customer->created_at?->format('d/m/Y H:i') }}</td>
                            </tr>
                            <tr>
                                <th>Người tạo:</th>
                                <td>{{ $customer->creator->name ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Cập nhật lần cuối:</th>
                                <td>{{ $customer->updated_at?->format('d/m/Y H:i') }}</td>
                            </tr>
                            @if($customer->converted_to_member_at)
                            <tr>
                                <th>Chuyển thành hội viên:</th>
                                <td>{{ $customer->converted_to_member_at->format('d/m/Y H:i') }}</td>
                            </tr>
                            @endif
                        </table>
                    </div>
                </div>
            </div>

            {{-- Lead mới nhất --}}
            @if($customer->latestLead)
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-warning text-dark">
                        <h5 class="mb-0">Lead mới nhất</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tr>
                                <th width="40%">Ngày liên hệ:</th>
                                <td>{{ $customer->latestLead->contact_date ? \Carbon\Carbon::parse($customer->latestLead->contact_date)->format('d/m/Y') : '-' }}</td>
                            </tr>
                            <tr>
                                <th>Nguồn:</th>
                                <td>{{ $customer->latestLead->source->name ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Trạng thái:</th>
                                <td>{{ $customer->latestLead->status->name ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Ghi chú:</th>
                                <td>{{ $customer->latestLead->note ?? '-' }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            @endif

            {{-- Đơn hàng mới nhất --}}
            @if($customer->latestOrder)
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">Đơn hàng mới nhất</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tr>
                                <th width="40%">Mã đơn:</th>
                                <td>{{ $customer->latestOrder->order_code }}</td>
                            </tr>
                            <tr>
                                <th>Ngày đặt:</th>
                                <td>{{ $customer->latestOrder->order_date ? \Carbon\Carbon::parse($customer->latestOrder->order_date)->format('d/m/Y') : '-' }}</td>
                            </tr>
                            <tr>
                                <th>Tổng tiền:</th>
                                <td>{{ number_format($customer->latestOrder->total_amount, 0, ',', '.') }} đ</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            @endif
        </div>

        {{-- Danh sách Leads --}}
        @if($customer->leads && $customer->leads->count() > 0)
        <div class="card shadow-sm mb-4">
            <div class="card-header">
                <h5 class="mb-0">Lịch sử Leads ({{ $customer->leads->count() }})</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Ngày liên hệ</th>
                                <th>Nguồn</th>
                                <th>Trạng thái</th>
                                <th>Ghi chú</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($customer->leads as $lead)
                            <tr>
                                <td>{{ $lead->contact_date ? \Carbon\Carbon::parse($lead->contact_date)->format('d/m/Y') : '-' }}</td>
                                <td>{{ $lead->source->name ?? '-' }}</td>
                                <td>{{ $lead->status->name ?? '-' }}</td>
                                <td>{{ Str::limit($lead->note, 50) }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endif
    </div>
@endsection
