@php
    $isEdit = isset($customer);
    $action = $isEdit
        ? route('customers.update', $customer->id)
        : route('customers.store');
@endphp
<div class="modal-header">
    <h5 class="modal-title">
        {{ $isEdit ? 'Cập nhật khách hàng' : 'Thêm mới khách hàng' }}
    </h5>
    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<form method="POST" action="{{ $action }}">
    @csrf
    @if($isEdit) @method('PUT') @endif
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Tên khách *</label>
                <input type="text" name="name" class="form-control"
                       value="{{ old('name', $customer->name ?? '') }}" required>
            </div>
            <div class="col-md-6">
                <label class="form-label">Số điện thoại</label>
                <input type="text" name="phone" class="form-control"
                       value="{{ old('phone', $customer->phone ?? '') }}">
            </div>
            <div class="col-md-6">
                <label class="form-label">Tên Facebook</label>
                <input type="text" name="facebook_name" class="form-control"
                       value="{{ old('facebook_name', $customer->facebook_name ?? '') }}">
            </div>
            <div class="col-md-6">
                <label class="form-label">Link Facebook</label>
                <input type="url" name="facebook_link" class="form-control"
                       value="{{ old('facebook_link', $customer->facebook_link ?? '') }}">
            </div>
            <div class="col-md-6">
                <label class="form-label">Zalo ID</label>
                <input type="text" name="zalo_id" class="form-control"
                       value="{{ old('zalo_id', $customer->zalo_id ?? '') }}">
            </div>
            <div class="col-md-6">
                <label class="form-label">Email</label>
                <input type="email" name="email" class="form-control"
                       value="{{ old('email', $customer->email ?? '') }}">
            </div>
            <div class="col-md-6">
                <label class="form-label">Loại khách</label>
                <select name="customer_type_id" class="form-select">
                    <option value="">-- Chọn --</option>
                    @foreach($customerTypes as $ct)
                        <option value="{{ $ct->id }}"
                                {{ old('customer_type_id', $customer->customer_type_id ?? '') == $ct->id ? 'selected' : '' }}>
                            {{ $ct->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-6">
                <label class="form-label">Trạng thái</label>
                <select name="customer_status" class="form-select">
                    <option value="lead" {{ old('customer_status', $customer->customer_status ?? 'lead') == 'lead' ? 'selected' : '' }}>Lead</option>
                    <option value="member" {{ old('customer_status', $customer->customer_status ?? '') == 'member' ? 'selected' : '' }}>Member</option>
                </select>
            </div>
            <div class="col-md-6">
                <label class="form-label">Khu vực</label>
                <select name="region_id" class="form-select">
                    <option value="">-- Chọn khu vực --</option>
                    @foreach($regions as $r)
                        <option value="{{ $r->id }}"
                                {{ old('region_id', $customer->region_id ?? '') == $r->id ? 'selected' : '' }}>
                            {{ $r->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-6">
                <label class="form-label">Nguồn (từ Lead)</label>
                <select name="source_id" class="form-select" disabled>
                    <option>-- Xem từ Lead liên kết --</option>
                </select>
                <small class="text-muted">Lấy từ bảng crm_leads</small>
            </div>
            <div class="col-12">
                <label class="form-label">Địa chỉ</label>
                <textarea name="address" class="form-control">{{ old('address', $customer->address ?? '') }}</textarea>
            </div>
            <div class="col-md-6">
                <label class="form-label">Biệt danh</label>
                <input type="text" name="nickname" class="form-control"
                       value="{{ old('nickname', $customer->nickname ?? '') }}">
            </div>
            <div class="col-md-6">
                <label class="form-label">Ghi chú nhóm</label>
                <input type="text" name="group_note" class="form-control"
                       value="{{ old('group_note', $customer->group_note ?? '') }}">
            </div>
            <div class="col-md-6">
                <label class="form-label">Đánh giá</label>
                <select name="is_potential" class="form-select">
                    <option value="0" {{ old('is_potential', $customer->is_potential ?? 0) == 0 ? 'selected' : '' }}>Không</option>
                    <option value="1" {{ old('is_potential', $customer->is_potential ?? 0) == 1 ? 'selected' : '' }}>Có (Tiềm năng)</option>
                </select>
                <small class="text-muted">Đánh dấu khách hàng tiềm năng</small>
            </div>
            <div class="col-md-6">
                <label class="form-label">Ghi chú (từ Lead)</label>
                <input type="text" class="form-control" disabled placeholder="-- Xem từ Lead liên kết --">
                <small class="text-muted">Lấy từ bảng crm_leads</small>
            </div>
            <div class="col-md-6">
                <label class="form-label">Người phụ trách</label>
                <select name="owner_id" class="form-select">
                    <option value="">-- Chọn --</option>
                    @foreach($users as $u)
                        <option value="{{ $u->id }}"
                                {{ old('owner_id', $customer->owner_id ?? '') == $u->id ? 'selected' : '' }}>
                            {{ $u->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-12">
                <label class="form-label">Ghi chú marketing (từ Lead)</label>
                <textarea name="marketing_note_info" class="form-control" rows="3" disabled placeholder="-- Xem từ Lead liên kết --"></textarea>
                <small class="text-muted">Lấy từ bảng crm_leads</small>
            </div>
        </div>
    <div class="modal-footer">
        <button class="btn btn-primary">
            {{ $isEdit ? 'Cập nhật' : 'Thêm mới' }}
        </button>
    </div>
</form>
</div>