@extends('layouts.app')
@section('title', 'Đăng nhập')
@section('content')
<div class="container mt-5">
	<div class="row justify-content-center">
		<div class="col-md-4">
			<h4 class="mb-4 text-center">Đăng nhập hệ thống</h4>
			@if (session('error'))
			<div class="alert alert-danger">{{ session('error') }}</div>
			@endif
			<form method="POST" action="{{ route('login') }}">
				@csrf
				<div class="form-group mb-3">
					<label for="email">Email</label>
					<input id="email" type="email" name="email" class="form-control" required autofocus value="{{ old('email') }}">
				</div>
				<div class="form-group mb-3">
					<label for="password">Mật khẩu</label>
					<input id="password" type="password" name="password" class="form-control" required>
				</div>
				<div class="form-check mb-3">
					<input class="form-check-input" type="checkbox" name="remember" id="remember">
					<label class="form-check-label" for="remember">Ghi nhớ đăng nhập</label>
				</div>
				<button type="submit" class="btn btn-primary w-100">Đăng nhập</button>
				<div class="mt-3 text-center">
					<a href="{{ route('register') }}">Chưa có tài khoản? Đăng ký</a>
				</div>
			</form>
		</div>
	</div>
</div>
@endsection
