<?php
namespace Database\Seeders;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
class RolePermissionSeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 */
	public function run(): void
	{
		// Xóa cache role/permission cũ
		app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

		$rolesPermissions = config('permissions');

		// ====== Tạo permissions ======
		$allPermissions = [];

		foreach ($rolesPermissions as $roleName => $perms) {
			if (isset($perms['*'])) {
				continue; // admin full quyền sẽ xử lý sau
			}
			foreach ($perms as $perm => $desc) {
				$permission = Permission::firstOrCreate(['name' => $perm]);
				$allPermissions[$perm] = $permission;
			}
		}

		// ====== Tạo roles và gắn permissions ======
		foreach ($rolesPermissions as $roleName => $perms) {
			$role = Role::firstOrCreate(['name' => $roleName]);

			if (isset($perms['*'])) {
				// Admin full quyền
				$role->syncPermissions(Permission::all());
			} else {
				$role->syncPermissions(array_keys($perms));
			}
		}

		// ====== Tạo users demo ======
		$users = [
			['name' => 'Admin', 'email' => 'admin@example.com', 'password' => '12345678', 'role' => 'admin'],
			['name' => 'Marketing Team', 'email' => 'marketing@example.com', 'password' => '12345678', 'role' => 'marketing'],
			['name' => 'Sales Team', 'email' => 'sales@example.com', 'password' => '12345678', 'role' => 'sales'],
			['name' => 'Kế toán', 'email' => 'ketoan@example.com', 'password' => '12345678', 'role' => 'accounting'],
			['name' => 'Kho', 'email' => 'warehouse@example.com', 'password' => '12345678', 'role' => 'warehouse'],
			['name' => 'Giám đốc', 'email' => 'manager@example.com', 'password' => '12345678', 'role' => 'management'],
		];

		foreach ($users as $userData) {
			$user = User::firstOrCreate(
				['email' => $userData['email']],
				['name' => $userData['name'], 'password' => Hash::make($userData['password'])]
			);
			$user->syncRoles($userData['role']);
		}

		echo "✅ RolePermissionSeeder: seeded successfully.\n";
	}
}
