<?php
namespace App\Services;
use App\Repositories\Interfaces\OrderRepositoryInterface;
use App\Repositories\Interfaces\LeadRepositoryInterface;
use App\Repositories\Interfaces\CustomerRepositoryInterface;
use App\Repositories\Interfaces\PaymentRepositoryInterface;
class DashboardService
{
	protected $orderRepo;
	protected $leadRepo;
	protected $customerRepo;
	protected $paymentRepo;
	public function __construct(
		OrderRepositoryInterface $orderRepo,
		LeadRepositoryInterface $leadRepo,
		CustomerRepositoryInterface $customerRepo,
		PaymentRepositoryInterface $paymentRepo
	) {
		$this->orderRepo    = $orderRepo;
		$this->leadRepo     = $leadRepo;
		$this->customerRepo = $customerRepo;
		$this->paymentRepo  = $paymentRepo;
	}
	public function getDashboardData(array $filters = []): array
	{
		// filters can include from/to/period if you implement them later
		$revenue_by_month = $this->orderRepo->revenueByMonth();
		$orders_by_month  = $this->orderRepo->ordersByMonth();
		$order_status_chart = $this->orderRepo->orderStatusCounts();
		$top_sales = $this->orderRepo->topSalespersons(5);
		$lead_sources = $this->leadRepo->leadSourceCounts();
		$revenue_by_month = $revenue_by_month->isEmpty()
			? collect([ ['month' => 'N/A', 'revenue' => 0] ])
			: $revenue_by_month;
		return [
			'total_customers' => $this->customerRepo->count(),
			'total_customers_buy' => $this->customerRepo->countPurchased(),
			'total_leads' => $this->leadRepo->count(),
			'total_orders' => $this->orderRepo->count(),
			'total_payments' => $this->paymentRepo->sumPayments(),

//			'recent_orders' => $this->orderRepo->getRecent(5),
			'recent_leads' => $this->leadRepo->getRecent(5),

			'revenue_by_month' => $revenue_by_month,
			'orders_by_month' => $orders_by_month,
			'order_status_chart' => $order_status_chart,
			'top_sales' => $top_sales,
			'lead_sources' => $lead_sources,
		];
	}
}
