<?php
namespace App\Repositories\Eloquent;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Repositories\Interfaces\ProductRepositoryInterface;
class ProductRepository implements ProductRepositoryInterface
{
	public function getAll()
	{
		return Product::with('category', 'mainImage.media.metadata', 'stocks')->withSum('stocks', 'qty')->paginate(20);
	}
	public function find($id)
	{
		return Product::findOrFail($id);
	}
	public function create(array $data)
	{
		return Product::create($data);
	}
	public function update($product, array $data)
	{
		$product->update($data);
		return $product;
	}
	public function delete($product)
	{
		return $product->delete();
	}
}
