<?php
namespace App\Providers;
use App\Repositories\Eloquent\CustomerRepository;
use App\Repositories\Eloquent\LeadRepository;
use App\Repositories\Eloquent\OrderRepository;
use App\Repositories\Eloquent\PaymentMethodRepository;
use App\Repositories\Eloquent\PaymentRepository;
use App\Repositories\Eloquent\ProductCategoryRepository;
use App\Repositories\Eloquent\ProductRepository;
use App\Repositories\Eloquent\UserRepository;
use App\Repositories\Eloquent\WarehouseRepository;
use App\Repositories\Interfaces\CustomerRepositoryInterface;
use App\Repositories\Interfaces\LeadRepositoryInterface;
use App\Repositories\Interfaces\OrderRepositoryInterface;
use App\Repositories\Interfaces\PaymentMethodRepositoryInterface;
use App\Repositories\Interfaces\PaymentRepositoryInterface;
use App\Repositories\Interfaces\ProductCategoryRepositoryInterface;
use App\Repositories\Interfaces\ProductRepositoryInterface;
use App\Repositories\Interfaces\UserRepositoryInterface;
use App\Repositories\Interfaces\WarehouseRepositoryInterface;
use Illuminate\Support\ServiceProvider;
class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
	    $this->app->bind(CustomerRepositoryInterface::class, CustomerRepository::class);
	    $this->app->bind(OrderRepositoryInterface::class, OrderRepository::class);
	    $this->app->bind(LeadRepositoryInterface::class, LeadRepository::class);
	    $this->app->bind(PaymentRepositoryInterface::class, PaymentRepository::class);
	    $this->app->bind(UserRepositoryInterface::class,UserRepository::class);
	    $this->app->bind(ProductRepositoryInterface::class,ProductRepository::class);
	    $this->app->bind(ProductCategoryRepositoryInterface::class,ProductCategoryRepository::class);
	    $this->app->bind(WarehouseRepositoryInterface::class,WarehouseRepository::class);
        $this->app->bind(PaymentMethodRepositoryInterface::class,PaymentMethodRepository::class);
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
}
