<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Warehouse extends Model
{
	protected $table = 'crm_warehouses';
	public $timestamps = false;
	protected $fillable = ['name','location','manager_id'];
	/**
	 * Người quản lý kho (user)
	 */
	public function manager()
	{
		return $this->belongsTo(User::class, 'manager_id');
	}
	/**
	 * Sản phẩm trong kho
	 */
	public function stocks(): Warehouse|HasMany {
		return $this->hasMany(\App\Models\CRM\ProductStock::class, 'warehouse_id');
	}
	/**
	 * Đơn hàng xuất từ kho này
	 */
	public function orders(): Warehouse|HasMany {
		return $this->hasMany(\App\Models\CRM\Order::class, 'warehouse_id');
	}
	/**
	 * Lịch sử dịch chuyển kho
	 */
	public function movements(): Warehouse|HasMany {
		return $this->hasMany(\App\Models\CRM\StockMovement::class, 'warehouse_id');
	}
}
