<?php
namespace App\Models;
// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable, HasRoles;
    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];
    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
	public function leadsAssigned(): User|HasMany {
		return $this->hasMany(\App\Models\CRM\Lead::class, 'assigned_to');
	}
	public function leadsCreated(): User|HasMany {
		return $this->hasMany(\App\Models\CRM\Lead::class, 'created_by');
	}
	public function ordersCreated(): User|HasMany {
		return $this->hasMany(\App\Models\CRM\Order::class, 'created_by');
	}
	public function approvals(): User|HasMany {
		return $this->hasMany(\App\Models\CRM\OrderApproval::class, 'approved_by');
	}
	public function avatar(): MorphOne {
		return $this->morphOne(MediaRelation::class, 'model')
		            ->where('usage_type', 'avatar');
	}
}
