<?php
namespace App\Models;
use App\Models\CRM\OrderItem;
use App\Models\CRM\ProductStock;
use App\Models\CRM\StockMovement;
use App\Traits\HasMedia;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\Relations\MorphOne;

class Product extends Model
{
	use HasMedia;
	protected $table = 'crm_product_catalog';
	protected $fillable = [
		'name',
		'sku',
		'price_agent',
		'price_retail',
		'quantity',
		'category_id',
	];
	protected $casts = [
		'price' => 'decimal:2',
		'price_agent' => 'decimal:2',
		'price_retail' => 'decimal:2',
	];
	protected function quantity(): Attribute
	{
		return Attribute::make(
			get: function ($value, $attributes) {
				if (array_key_exists('stocks_sum_qty', $attributes)) {
					return (int) $attributes['stocks_sum_qty'];
				}
				if ($this->relationLoaded('stocks')) {
					return (int) $this->stocks->sum('qty');
				}
				return (int) ($value ?? 0);
			}
		);
	}

	public function category(): BelongsTo {
		return $this->belongsTo(ProductCategory::class, 'category_id');
	}
	public function orderItems()
	{
		return $this->hasMany(OrderItem::class, 'product_id');
	}
	public function stocks()
	{
		return $this->hasMany(ProductStock::class, 'product_id');
	}
	public function movements()
	{
		return $this->hasMany(StockMovement::class, 'product_id');
	}
	public function images(): MorphMany {
		return $this->mediaRelations('gallery');
	}
	public function mainImage(): MorphOne {
		return $this->mediaRelation('main_image');
	}
}
