<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
class OrderNotification extends Model
{
	use HasFactory;
	protected $table = 'crm_order_notifications';
	protected $fillable = [
		'order_id',
		'user_id',
		'type',
		'title',
		'message',
		'is_read',
		'read_at',
	];
	protected $casts = [
		'is_read' => 'boolean',
		'read_at' => 'datetime',
	];
	// -------------------------
	// Relationships
	// -------------------------
	public function order()
	{
		return $this->belongsTo(CrmOrder::class, 'order_id');
	}
	public function user()
	{
		return $this->belongsTo(User::class, 'user_id');
	}
	// -------------------------
	// Helpers
	// -------------------------
	// Đánh dấu đã đọc
	public function markAsRead()
	{
		$this->update([
			'is_read' => true,
			'read_at' => now()
		]);
	}
	// Kiểm tra unread
	public function scopeUnread($query)
	{
		return $query->where('is_read', false);
	}
}
