<?php
namespace App\Models\CRM;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
class StockMovement extends Model
{
	use HasFactory;
	protected $table = 'crm_stock_movements';
	protected $fillable = [
		'product_id',
		'warehouse_id',
		'change_qty',
		'reason',
		'reference_id',
		'created_by',
	];
	public function product()
	{
		return $this->belongsTo(\App\Models\ProductCatalog::class);
	}
	public function warehouse()
	{
		return $this->belongsTo(\App\Models\Warehouse::class);
	}
	public function creator()
	{
		return $this->belongsTo(\App\Models\User::class, 'created_by');
	}
}
