<?php
namespace App\Models\CRM;
use App\Models\Product;
use App\Models\Warehouse;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProductStock extends Model
{
	use HasFactory;
	protected $table = 'crm_product_stock';
	public $timestamps = false;
	protected $fillable = ['product_id', 'warehouse_id', 'qty', 'last_updated'];
	protected $dates = ['last_updated'];
	public function product(): BelongsTo {
		return $this->belongsTo(Product::class);
	}
	public function warehouse(): BelongsTo {
		return $this->belongsTo(Warehouse::class);
	}
}
