<?php
namespace App\Models\CRM;
use App\Models\Product;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OrderItem extends Model
{
	use HasFactory;
	protected $table = 'crm_order_items';
    public $timestamps = false;
    protected $fillable = [
		'order_id',
		'product_id',
		'quantity',
		'unit_price',
        'line_total',
	];
    protected $casts = [
        'quantity' => 'integer',
        'unit_price' => 'decimal:2',
        'line_total' => 'decimal:2',
    ];
	public function order(): BelongsTo
    {
		return $this->belongsTo(Order::class, 'order_id');
	}

	public function product(): BelongsTo
    {
		return $this->belongsTo(Product::class, 'product_id');
	}
	public function getLineTotalAttribute(): float|int
    {
		return $this->quantity * $this->unit_price;
	}
}
