<?php
namespace App\Models\CRM;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
class MarketingRating extends Model
{
	use HasFactory;
	protected $table = 'crm_marketing_ratings';
	protected $fillable = [
		'lead_id',
		'rating',
		'note',
		'created_by',
	];
	public function lead()
	{
		return $this->belongsTo(Lead::class);
	}
	public function creator()
	{
		return $this->belongsTo(\App\Models\User::class, 'created_by');
	}
}
