<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
class WarehouseRequest extends FormRequest
{
	public function authorize(): bool
	{
		return $this->user()->can('warehouse.export'); // or a new permission 'warehouse.manage'
	}
	public function rules(): array
	{
		return [
			'name' => 'required|string|max:255',
			'location' => 'nullable|string|max:255',
			'manager_id' => 'nullable|exists:users,id',
		];
	}
}
