<?php
namespace App\Http\Requests;
use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;
class UserStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
	    return auth()->check() && auth()->user()->can('create', User::class);
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
	    $rules = [
		    'name' => 'required|string|max:255',
		    'email' => 'required|email|unique:users,email',
		    'password' => 'required|string|min:6|confirmed',
	    ];

	    if (auth()->user()->hasRole('admin')) {
		    $rules['roles'] = 'nullable|array';
		    $rules['roles.*'] = 'exists:roles,name';
	    }
	    return $rules;
    }
}
