<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
class UpdateCustomerRequest extends FormRequest
{
	public function authorize(): bool
	{
		$user = $this->user();
		// Admin và Marketing luôn được update
		if ($user->hasAnyRole(['admin', 'marketing'])) {
			return true;
		}
		// Sales chỉ được update khách hàng mình phụ trách
		if ($user->hasRole('Sales')) {
			$customerId = $this->route('customer'); // Lấy từ route parameter
			return $this->user()->id === optional($this->route('customer_model'))->owner_id;
		}
		return false;
	}
	public function rules(): array
	{
		return [
			'name'            => 'sometimes|required|string|max:255',
			'phone'           => 'nullable|string|max:50',
			'facebook_name'   => 'nullable|string|max:255',
			'facebook_link'   => 'nullable|url|max:511',
			'zalo_id'         => 'nullable|string|max:255',
			'customer_type_id'=> 'nullable|exists:crm_customer_types,id',
			'region_id'       => 'nullable|exists:crm_regions,id',
			'email'           => 'nullable|email|max:255',
			'address'         => 'nullable|string',
			'nickname'        => 'nullable|string|max:255',
			'group_note'      => 'nullable|string|max:255',
			'owner_id'        => 'nullable|exists:users,id',
			'customer_status' => 'nullable|in:lead,member',
			'is_potential'    => 'nullable|boolean',
		];
	}
	public function messages(): array
	{
		return (new StoreCustomerRequest())->messages();
	}
}
