<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
class StoreCustomerRequest extends FormRequest
{
	public function authorize(): bool
	{
		return auth()->user()->hasAnyRole(['admin', 'marketing']);
	}
	public function rules(): array
	{
		return [
			'name'            => 'required|string|max:255',
			'phone'           => 'nullable|string|max:50',
			'facebook_name'   => 'nullable|string|max:255',
			'facebook_link'   => 'nullable|url|max:511',
			'zalo_id'         => 'nullable|string|max:255',
			'customer_type_id'=> 'nullable|exists:crm_customer_types,id',
			'region_id'       => 'nullable|exists:crm_regions,id',
			'email'           => 'nullable|email|max:255',
			'address'         => 'nullable|string',
			'nickname'        => 'nullable|string|max:255',
			'group_note'      => 'nullable|string|max:255',
			'owner_id'        => 'nullable|exists:users,id',
			'customer_status' => 'nullable|in:lead,member',
			'is_potential'    => 'nullable|boolean',
		];
	}

	public function messages(): array
	{
		return [
			'name.required'           => 'Tên khách hàng là bắt buộc.',
			'name.max'                => 'Tên khách hàng không được vượt quá 255 ký tự.',
			'phone.max'               => 'Số điện thoại không được vượt quá 50 ký tự.',
			'facebook_name.max'       => 'Tên Facebook không được vượt quá 255 ký tự.',
			'facebook_link.url'       => 'Link Facebook không hợp lệ.',
			'facebook_link.max'       => 'Link Facebook không được vượt quá 511 ký tự.',
			'customer_type_id.exists' => 'Loại khách không tồn tại.',
			'region_id.exists'        => 'Khu vực không tồn tại.',
			'email.email'             => 'Email không hợp lệ.',
			'email.max'               => 'Email không được vượt quá 255 ký tự.',
			'nickname.max'            => 'Biệt danh không được vượt quá 255 ký tự.',
			'group_note.max'          => 'Ghi chú nhóm không được vượt quá 255 ký tự.',
			'owner_id.exists'         => 'Người phụ trách không tồn tại.',
			'customer_status.in'      => 'Trạng thái khách hàng không hợp lệ (lead hoặc member).',
		];
	}
}
