<?php
namespace App\Http\Controllers;
use App\Http\Requests\WarehouseRequest;
use App\Models\Warehouse;
use App\Services\WarehouseService;
use App\Models\CRM\ProductStock as CrmProductStock;
use Illuminate\Http\Request;
class WarehouseController extends Controller
{
	public function __construct(protected WarehouseService $service)
	{
		$this->middleware('can:warehouse.view_stock')->only(['index','show']);
		$this->middleware('can:warehouse.export')->only(['create','store','edit','update','destroy']);
	}
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
	    $warehouses = $this->service->list();
	    return view('warehouses.index', compact('warehouses'));
    }
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
	    return view('warehouses.create');
    }
    /**
     * Store a newly created resource in storage.
     */
    public function store(WarehouseRequest $request)
    {
	    $this->service->create($request->validated());
	    return redirect()->route('warehouses.index')->with('success','Tạo kho thành công');
    }
    /**
     * Display the specified resource.
     */
    public function show(Warehouse $warehouse)
    {
        //
    }
    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Warehouse $warehouse)
    {
	    return view('warehouses.edit', compact('warehouse'));
    }
    /**
     * Update the specified resource in storage.
     */
    public function update(WarehouseRequest $request, Warehouse $warehouse)
    {
	    $this->service->update($warehouse, $request->validated());
	    return redirect()->route('warehouses.index')->with('success','Cập nhật kho thành công');
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Warehouse $warehouse)
    {
	    $this->service->delete($warehouse);
	    return redirect()->route('warehouses.index')->with('success','Xóa kho thành công');
    }
	public function inventory(Warehouse $warehouse)
	{
		$inventory = CrmProductStock::query()
		                            ->with('product')
		                            ->where('warehouse_id', $warehouse->id)
		                            ->get();

		return view('warehouses.inventory', compact('warehouse', 'inventory'));
	}
}
