<?php
namespace App\Http\Controllers;
use App\Http\Requests\UserStoreRequest;
use App\Http\Requests\UserUpdateRequest;
use App\Models\User;
use App\Services\UserService;
use Illuminate\Http\Request;
class UserController extends Controller
{
	public function __construct(protected UserService $service) {
		$this->middleware('auth');
	}
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
	    $this->authorize('viewAny', User::class);
	    $users = $this->service->paginateUsers(15);
	    return view('users.index', compact('users'));
    }
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
	    $this->authorize('create', User::class);
	    return view('users.create');
    }
    /**
     * Store a newly created resource in storage.
     */
	public function store(UserStoreRequest $request)	{
		$this->authorize('create', User::class);
		$this->service->createUser($request->validated());
		return redirect()->route('users.index')->with('success', 'User created successfully');
	}
    /**
     * Display the specified resource.
     */
    public function show(User $user)
    {
        //
    }
    /**
     * Show the form for editing the specified resource.
     */
    public function edit(User $user)
    {
	    $this->authorize('update', $user);
	    return view('users.edit', compact('user'));
    }
    /**
     * Update the specified resource in storage.
     */
    public function update(UserUpdateRequest  $request, User $user)
    {
	    $this->authorize('update', $user);
	    $updated = $this->service->updateUser($user->id, $request->validated());
	    return redirect()->route('users.index')->with('success', 'User updated successfully');
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(User $user)
    {
	    $this->authorize('delete', $user);
	    $this->service->deleteUser($user->id);
	    return redirect()->route('users.index')->with('success', 'User deleted successfully');
    }
}
