<?php
namespace App\Http\Controllers;
use App\Http\Requests\ProductRequest;
use App\Models\Product;
use App\Services\ProductService;
use Illuminate\Http\Request;

class ProductController extends Controller
{
	protected $service;
	public function __construct(ProductService $service)
	{
		$this->authorizeResource(Product::class, 'product');
		$this->service = $service;
	}
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
	    $products = $this->service->list();
	    return view('products.index', compact('products'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
	    $selections = $this->service->formSelections();
	    $formData = $this->service->prepareFormData(null);
	    return view('products.create', [
		    'categories' => $selections['categories'],
		    'warehouses' => $selections['warehouses'],
		    'formData' => $formData,
	    ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ProductRequest  $request)
    {
	    $this->service->create($request->validated());
	    return redirect()->route('products.index')->with('success','Tạo sản phẩm thành công');

    }

    /**
     * Display the specified resource.
     */
    public function show(Product $product)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Product $product)
    {
	    $selections = $this->service->formSelections();
	    $formData = $this->service->prepareFormData($product->load('stocks'));
	    return view('products.edit', [
		    'product' => $product,
		    'categories' => $selections['categories'],
		    'warehouses' => $selections['warehouses'],
		    'formData' => $formData,
	    ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(ProductRequest  $request, Product $product)
    {
//	    $this->authorize('update', $product);
	    $this->service->update($product, $request->validated());
	    return redirect()->route('products.index')->with('success','Cập nhật sản phẩm thành công');
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Product $product)
    {
	    $this->service->delete($product);
	    return redirect()->route('products.index')->with('success','Xóa sản phẩm thành công');
    }
}
