<?php
namespace App\Http\Controllers;
use App\Services\NotificationService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class NotificationController extends Controller
{
	public function __construct(
		protected NotificationService $notificationService
	) {}
    /**
     * Danh sách thông báo
     * Display a listing of the resource.
     */
    public function index()
    {
	    $userId = Auth::id();
	    $notifications = $this->notificationService->getAllNotifications($userId, 30);
	    return view('notifications.index', compact('notifications'));
    }
	/**
	 * Đánh dấu đã đọc
	 */
	public function markAsRead($id)
	{
		$this->notificationService->markAsRead($id);
		return back()->with('success', 'Đã đánh dấu thông báo đã đọc');
	}
	/**
	 * Đánh dấu tất cả đã đọc
	 */
	public function markAllAsRead()
	{
		$userId = Auth::id();
		$this->notificationService->markAllAsRead($userId);
		return back()->with('success', 'Đã đánh dấu tất cả thông báo đã đọc');
	}
	/**
	 * API: Lấy số thông báo chưa đọc
	 */
	public function getUnreadCount()
	{
		$userId = Auth::id();
		$count = $this->notificationService->getUnreadCount($userId);
		return response()->json(['count' => $count]);
	}
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }
    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }
    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }
    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
