<?php
namespace App\Http\Controllers\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
class LoginController extends Controller
{
	public function showLoginForm()
	{
		return view('auth.login');
	}
	public function login(Request $request)
	{
		$credentials = $request->validate([
			'email' => 'required|email',
			'password' => 'required',
		]);
		if (Auth::attempt($credentials, $request->remember)) {
			$request->session()->regenerate();
			return redirect()->intended('/customers');
		}
		return back()->with('error', 'Sai email hoặc mật khẩu');
	}
	public function logout(Request $request)
	{
		Auth::logout();
		$request->session()->invalidate();
		$request->session()->regenerateToken();
		return redirect()->route('login');
	}
}
